/* $Id: asm.h,v 1.1 1995/11/23 18:15:08 stuart Exp $ */

/* Defintions of macros which allow assembler files to be used with both
 * icc and lcc.
 */

#ifdef _ICC
#define LABEL(l) $##l:
#define GLABEL(l) $##l: ; global $##l
#define _TMP(l) _l##l##_
#define TMP(l) _TMP(l)
#define LDCODEADDR(l) ldc (l)-TMP(__LINE__); ldpi; TMP(__LINE__):
#define CJ(l)         cj (l)-TMP(__LINE__); TMP(__LINE__):
#define LEND(l)       ldc TMP(__LINE__)-(l); lend; TMP(__LINE__):
#define LDCEXPR(x)    ldc x
#define HAS_GSB 1
#elif defined(__LCC__)
#define LABEL(l) @l
#define GLABEL(l) _##l
#define LDCODEADDR(l) ldpi @l
#define CJ(l)         cj @l
#define LEND(l)       lend @l
#define HAS_GSB 0
#else
#error Unknown compiler
#endif
