/* $Id: time.h,v 1.1 1994/09/21 16:41:03 stuart Exp $ */

/* The <time.h> header is used by the procedures that deal with time.
 * Handling time is surprisingly complicated, what with GMT, local time
 * and other factors.  Although the Bishop of Ussher (1581-1656) once
 * calculated that based on the Bible, the world began on 12 Oct. 4004 BC
 * at 9 o'clock in the morning, in the UNIX world time begins at midnight, 
 * 1 Jan. 1970 GMT.  Before that, all was NULL and (void).
 */

#ifndef _TIME_H
#define _TIME_H

#include <minix/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#define CLOCKS_PER_SEC    60	/* MINIX always uses 60 Hz, even in Europe */

#ifdef _POSIX_SOURCE
#define CLK_TCK CLOCKS_PER_SEC
#endif

#ifndef NULL
#define NULL    ((void *)0)
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef __size_t size_t;
#endif

#ifndef _TIME_T
#define _TIME_T
typedef __time_t time_t;
#endif

#ifndef _CLOCK_T
#define _CLOCK_T
typedef __clock_t clock_t;	/* time in ticks since process started */
#endif

struct tm 
{
  int tm_sec;			/* seconds after the minute [0, 59] */
  int tm_min;			/* minutes after the hour [0, 59] */
  int tm_hour;			/* hours since midnight [0, 23] */
  int tm_mday;			/* day of the month [1, 31] */
  int tm_mon;			/* months since January [0, 11] */
  int tm_year;			/* years since 1900 */
  int tm_wday;			/* days since Sunday [0, 6] */
  int tm_yday;			/* days since January 1 [0, 365] */
  int tm_isdst;			/* Daylight Saving Time flag */
};

extern char *tzname[];

clock_t clock(void);
double difftime(time_t _time1, time_t _time0);
time_t mktime(struct tm *_timeptr);
time_t time(time_t *_timeptr);
char *asctime(const struct tm *_timeptr);
char *ctime(const time_t *_timer);
struct tm *gmtime(const time_t *_timer);
struct tm *localtime(const time_t *_timer);
size_t strftime(char *_s, size_t _max, const char *_fmt, const struct tm *_timep);

#ifdef _POSIX_SOURCE
void tzset(void);
#endif

#ifdef _MINIX
int stime(time_t *_top);
#endif

#ifdef __cplusplus
}
#endif

#endif
