/* $Id: types.h,v 1.3 1995/10/27 18:58:59 stuart Exp $ */

#ifndef _SYS_TYPES_H
#define _SYS_TYPES_H

#include <minix/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _POSIX_SOURCE
#ifndef _SIZE_T
#define _SIZE_T
typedef __size_t size_t;
#endif
#ifndef _SSIZE_T
#define _SSIZE_T
typedef __ssize_t ssize_t;
#endif
typedef __dev_t dev_t;
typedef __gid_t gid_t;
typedef __ino_t ino_t;
typedef __mode_t mode_t;
typedef __nlink_t nlink_t;
typedef __off_t off_t;
typedef __pid_t pid_t;
typedef __uid_t uid_t;
#endif

#ifdef _MINIX
#ifndef _TIME_T
#define _TIME_T
typedef __time_t time_t;
#endif
#ifndef _CLOCK_T
#define _CLOCK_T
typedef __clock_t clock_t;
#endif
typedef __zone_t zone_t;
typedef __block_t block_t;
typedef __bit_t bit_t;
typedef __zone1_t zone1_t;
typedef __bitchunk_t bitchunk_t;
typedef __u8_t u8_t;
typedef __u16_t u16_t;
typedef __u32_t u32_t;
typedef __i8_t i8_t;
typedef __i16_t i16_t;
typedef __i32_t i32_t;
typedef __caddr_t caddr_t;
typedef __sighandler_t sighandler_t;
typedef __vir_clicks_t vir_clicks_t;
typedef __phys_bytes_t phys_bytes_t;
typedef __phys_clicks_t phys_clicks_t;
typedef __vir_bytes_t vir_bytes_t;
#endif

/* The following types are needed because MINIX uses K&R style function
 * definitions (for maximum portability).  When a short, such as dev_t, is
 * passed to a function with a K&R definition, the compiler automatically
 * promotes it to an int.  The prototype must contain an int as the parameter,
 * not a short, because an int is what an old-style function definition
 * expects.  Thus using dev_t in a prototype would be incorrect.  It would be
 * sufficient to just use int instead of dev_t in the prototypes, but Dev_t
 * is clearer.
 */
typedef int            Dev_t;
typedef int 	       Gid_t;
typedef int 	     Nlink_t;
typedef int 	       Uid_t;
typedef int             U8_t;
typedef unsigned long  U32_t;
typedef int             I8_t;
typedef int            I16_t;
typedef long            I32_t;

/* ANSI C makes writing down the promotion of unsigned types very messy.  When
 * sizeof(short) == sizeof(int), there is no promotion, so the type stays
 * unsigned.  When the compiler is not ANSI, there is usually no loss of
 * unsignedness, and there are usually no prototypes so the promoted type
 * doesn't matter.  The use of types like Ino_t is an attempt to use ints
 * (which are not promoted) while providing information to the reader.
 */

#if _EM_WSIZE == 2
typedef unsigned int      Ino_t;
typedef unsigned int    Zone1_t;
typedef unsigned int Bitchunk_t;
typedef unsigned int      U16_t;
typedef unsigned int     Mode_t;
#else
typedef int	          Ino_t;
typedef int 	        Zone1_t;
typedef int	     Bitchunk_t;
typedef int	          U16_t;
typedef int              Mode_t;
#endif

#ifdef __cplusplus
}
#endif
 
#endif
