/* $Id: stat.h,v 1.1 1994/09/21 16:41:39 stuart Exp $ */

#ifndef _STAT_H
#define _STAT_H

#include <minix/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _POSIX_SOURCE
struct stat 
{
  __dev_t st_dev;		/* major/minor device number */
  __ino_t st_ino;		/* i-node number */
  __mode_t st_mode;		/* file mode, protection bits, etc. */
  short int st_nlink;		/* # links; TEMPORARY HACK: should be nlink_t*/
  __uid_t st_uid;		/* uid of the file's owner */
  short int st_gid;		/* gid; TEMPORARY HACK: should be gid_t */
  __dev_t st_rdev;		/* raw device this file is located on */
  __off_t st_size;		/* file size */
  __time_t st_atime;		/* time of last access */
  __time_t st_mtime;		/* time of last data modification */
  __time_t st_ctime;		/* time of last file status change */
};

#define __S_IFMT  ((__mode_t)0170000)	/* type of file */
#define __S_IFLNK ((__mode_t)0120000)   /* symbolic link */
#define __S_IFREG ((__mode_t)0100000)	/* regular */
#define __S_IFBLK ((__mode_t)0060000)	/* block special */
#define __S_IFDIR ((__mode_t)0040000)  	/* directory */
#define __S_IFCHR ((__mode_t)0020000)	/* character special */
#define __S_IFIFO ((__mode_t)0010000)	/* this is a FIFO */

#ifdef _MINIX
#define S_IFMT  __S_IFMT
#define S_IFLNK __S_IFLNK
#define S_IFREG __S_IFREG
#define S_IFBLK __S_IFBLK
#define S_IFDIR __S_IFDIR
#define S_IFCHR __S_IFCHR
#define S_IFIFO __S_IFIFO
#define S_ISVTX ((__mode_t)0001000)	/* sticky bit */
#endif

#define S_ISUID ((__mode_t)0004000)	/* set user id on execution */
#define S_ISGID ((__mode_t)0002000)	/* set group id on execution */
#define S_IRWXU ((__mode_t)0000700)	/* owner:  rwx------ */
#define S_IRUSR ((__mode_t)0000400)	/* owner:  r-------- */
#define S_IWUSR ((__mode_t)0000200)	/* owner:  -w------- */
#define S_IXUSR ((__mode_t)0000100)	/* owner:  --x------ */

#define S_IRWXG ((__mode_t)0000070)	/* group:  ---rwx--- */
#define S_IRGRP ((__mode_t)0000040)	/* group:  ---r----- */
#define S_IWGRP ((__mode_t)0000020)	/* group:  ----w---- */
#define S_IXGRP ((__mode_t)0000010)	/* group:  -----x--- */

#define S_IRWXO ((__mode_t)0000007)	/* others: ------rwx */
#define S_IROTH ((__mode_t)0000004)	/* others: ------r-- */ 
#define S_IWOTH ((__mode_t)0000002)	/* others: -------w- */
#define S_IXOTH ((__mode_t)0000001)	/* others: --------x */

#define S_ISREG(m)	(((m) & __S_IFMT) == __S_IFREG)	/* is a reg file */
#ifdef _MINIX
#define S_ISLNK(m)      (((m) & __S_IFMT) == __S_IFLNK) /* is a symlink */
#endif
#define S_ISDIR(m)	(((m) & __S_IFMT) == __S_IFDIR)	/* is a directory */
#define S_ISCHR(m)	(((m) & __S_IFMT) == __S_IFCHR)	/* is a char spec */
#define S_ISBLK(m)	(((m) & __S_IFMT) == __S_IFBLK)	/* is a block spec */
#define S_ISFIFO(m)	(((m) & __S_IFMT) == __S_IFIFO)	/* is a pipe/FIFO */

int chmod(const char *_path, __mode_t _mode);
int fstat(int _fildes, struct stat *_buf);
int mkdir(const char *_path, __mode_t _mode);
int mkfifo(const char *_path, __mode_t _mode);
int stat(const char *_path, struct stat *_buf);
__mode_t umask(__mode_t _cmask);
#ifdef _MINIX
int lstat(const char *_path, struct stat *_buf);
#endif
#endif

#ifdef __cplusplus
}
#endif

#endif
