/* $Id: stdlib.h,v 1.2 1995/10/27 18:45:53 stuart Exp $ */

#ifndef _STDLIB_H
#define _STDLIB_H

#include <minix/types.h>

#ifdef _cplusplus
extern "C" {
#endif

#ifndef NULL
#define NULL    ((void *)0)
#endif

#define EXIT_FAILURE       1	/* standard error return using exit() */
#define EXIT_SUCCESS       0	/* successful return using exit() */
#define RAND_MAX       32767	/* largest value generated by rand() */
#define MB_CUR_MAX         1	/* max value of multibyte character in MINIX */

typedef __div_t div_t;
typedef __ldiv_t ldiv_t;

#ifndef _SIZE_T
#define _SIZE_T
typedef __size_t size_t;
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef __wchar_t wchar_t;
#endif

void abort(void);
int abs(int _j);
int atexit(void (*_func)(void));
double atof(const char *_nptr);
int atoi(const char *_nptr);
long atol(const char *_nptr);
void *calloc(size_t _nmemb, size_t _size);
div_t div(int _numer, int _denom);
void exit(int _status);
void free(void *_ptr);
char *getenv(const char *_name);
long labs(long _j);
ldiv_t ldiv(long _numer, long _denom);
void *malloc(size_t _size);
int mblen(const char *_s, size_t _n);
size_t mbstowcs(wchar_t *_pwcs, const char *_s, size_t _n);
int mbtowc(wchar_t *_pwc, const char *_s, size_t _n);
int rand(void);
void *realloc(void *_ptr, size_t _size);
void srand(unsigned int _seed);
double strtod(const char *_nptr, char **_endptr);
long strtol(const char *_nptr, char **_endptr, int _base);
int system(const char *_string);
size_t wcstombs(char *_s, const wchar_t *_pwcs, size_t _n);
int wctomb(char *_s, wchar_t _wchar);
void *bsearch(const void *_key, const void *_base, size_t _nmemb, size_t _size, int (*compar) (const void *, const void *));
void qsort(void *_base, size_t _nmemb, size_t _size, int (*compar) (const void *, const void *));
unsigned long int strtoul(const char *_nptr, char **_endptr, int _base);

#ifdef _MINIX
int putenv(const char *_name);
int getopt(int _argc, char **_argv, char *_opts);
extern char *optarg;
extern int optind, opterr, optopt;
#endif

#ifdef __cplusplus
}
#endif

#endif /* STDLIB_H */
