/* $Id: signal.h,v 1.4 1995/03/06 18:59:00 stuart Exp $ */

/* The <signal.h> header defines all the ANSI and POSIX signals.
 * MINIX supports all the signals required by POSIX. They are defined below.
 * Some additional signals are also supported.
 */

#ifndef _SIGNAL_H
#define _SIGNAL_H

#include <minix/types.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef __sig_atomic_t sig_atomic_t;

#ifdef _POSIX_SOURCE
#ifndef _SIGSET_T
#define _SIGSET_T
typedef __sigset_t sigset_t;
#endif
#endif

#define _NSIG             22	/* number of signals used */

#ifdef _POSIX_SOURCE
#define SIGHUP             1	/* hangup */
#endif
#define SIGINT             2	/* interrupt */
#ifdef _POSIX_SOURCE
#define SIGQUIT            3	/* quit */
#endif
#define SIGILL             4	/* illegal instruction */
#ifdef _MINIX
#define SIGTRAP            5	/* trace trap (not reset when caught) */
#endif
#define SIGABRT            6	/* IOT instruction */
#ifdef _MINIX
#define SIGIOT             6	/* SIGABRT for people who speak PDP-11 */
#define SIGUNUSED          7	/* spare code */
#endif
#define SIGFPE             8	/* floating point exception */
#ifdef _POSIX_SOURCE
#define SIGKILL            9	/* kill (cannot be caught or ignored) */
#define SIGUSR1           10	/* user defined signal # 1 */
#endif
#define SIGSEGV           11	/* segmentation violation */
#ifdef _POSIX_SOURCE
#define SIGUSR2           12	/* user defined signal # 2 */
#define SIGPIPE           13	/* write on a pipe with no one to read it */
#define SIGALRM           14	/* alarm clock */
#endif
#define SIGTERM           15	/* software termination signal from kill */
#ifdef _MINIX
/*efine SIGSTKFLT         16	 * used by kernel to indicate stack fault */
#define SIGEMT             7	/* obsolete */
#define SIGBUS            10	/* obsolete */
#endif

#ifdef _POSIX_SOURCE
#define SIGWINCH          16	/* window size changed */
#define SIGCHLD           17	/* child process terminated or stopped */
#define SIGCONT           18	/* continue if stopped */
#define SIGSTOP           19	/* stop signal */
#define SIGTSTP           20	/* interactive stop signal */
#define SIGTTIN           21	/* background process wants to read */
#define SIGTTOU           22	/* background process wants to write */

/* Macros used as function pointers. */
#define SIG_ERR    ((__sighandler_t) -1)	/* error return */
#define SIG_DFL	   ((__sighandler_t)  0)	/* default signal handling */
#define SIG_IGN	   ((__sighandler_t)  1)	/* ignore signal */
#endif

#ifdef _MINIX
#define SIG_HOLD   ((__sighandler_t)  2)	/* block signal */
#define SIG_CATCH  ((__sighandler_t)  3)	/* catch signal */
#endif

#ifdef _POSIX_SOURCE
struct sigaction 
{
  __sighandler_t sa_handler;	/* SIG_DFL, SIG_IGN, or pointer to function */
  sigset_t sa_mask;		/* signals to be blocked during handler */
  int sa_flags;			/* special flags */
};

/* Fields for sa_flags. */
#define SA_ONSTACK   0x0001	/* deliver signal on alternate stack */
#define SA_RESETHAND 0x0002	/* reset signal handler when signal caught */
#define SA_NODEFER   0x0004	/* don't block signal while catching it */
#define SA_RESTART   0x0008	/* automatic system call restart */
#define SA_SIGINFO   0x0010	/* extended signal handling */
#define SA_NOCLDWAIT 0x0020	/* don't create zombies */
#define SA_NOCLDSTOP 0x0040	/* don't receive SIGCHLD when child stops */
#define SA_COMPAT    0x0080	/* internal flag for old signal catchers */
#define SA_NOGSB     0x0100	/* don't put a GSB on the signal stack */

#define SIG_BLOCK          0	/* for blocking signals */
#define SIG_UNBLOCK        1	/* for unblocking signals */
#define SIG_SETMASK        2	/* for setting the signal mask */
#define SIG_INQUIRE        4	/* for internal use only */
#endif

int raise(int _sig);
__sighandler_t signal(int _sig, __sighandler_t _func);

#ifdef _POSIX_SOURCE
int kill(__pid_t _pid, int _sig);
int sigaction(int _sig, const struct sigaction *_act, struct sigaction *_oact);
int sigaddset(sigset_t *_set, int _sig);
int sigdelset(sigset_t *_set, int _sig);
int sigemptyset(sigset_t *_set);
int sigfillset(sigset_t *_set);
int sigismember(sigset_t *_set, int _sig);
int sigpending(sigset_t *_set);
int sigprocmask(int _how, const sigset_t *_set, sigset_t *_oset);
int sigsuspend(const sigset_t *_sigmask);
#endif

#ifdef __cplusplus
}
#endif

#endif
