/* $Id: mntent.h,v 1.1 1994/09/21 16:41:03 stuart Exp $ */

/* The mtab.h header is used to access the mounted file system database */

#ifndef _MNTENT_H
#define _MNTENT_H

#ifndef _STDIO_H
#include <stdio.h>
#endif

#define MTAB		"/etc/mtab"
#define MOUNTED		"/etc/mtab"
#define FSTAB		"/etc/fstab"
#define MTABLOCK	"/etc/mtab.lock"

struct mntent {
  char *mnt_fsname;			/* device */
  char *mnt_dir;			/* mount point */
  char *mnt_type;			/* filesystem type */
  char *mnt_opts;			/* options */
};

/* File system types */

#define MNTTYPE_MINIX1	"1"		/* Minix version 1 */
#define MNTTYPE_MINIX2	"2"		/* Minix version 2 */
#define MNTTYPE_IGNORE	"ignore"	/* ignore this entry */

/* File system options */

#define MNTOPT_RW	"rw"		/* readwrite */
#define MNTOPT_RO	"ro"		/* readonly */
#define MNTOPT_NOAUTO	"noauto"	/* no automount */

/* Access functions */

#ifndef _ANSI_H
#include <ansi.h>
#endif

_PROTOTYPE( FILE *setmntent, (char *_file, char * _mode)		);
_PROTOTYPE( struct mntent *getmntent, (FILE *_mf)			);
_PROTOTYPE( int addmntent, (FILE *_mf, struct mntent *_ent)		);
_PROTOTYPE( char *hasmntopt, (struct mntent *_ent, char *_opt)		);
_PROTOTYPE( int endmntent, (FILE *_mf)					);

#define setmntent(f,m)		(fopen((f),(m)))
#define endmntent(f)		(fclose(f) == 0)

#endif /* _MNTENT_H */
