/* $Id: types.h,v 1.3 1995/10/27 18:53:25 stuart Exp $ */

#ifndef _MINIX_TYPES_H
#define _MINIX_TYPES_H

/*

These are kernel dependent hidden types, which are used by all prototypes
in order not to violate POSIX namespace.  They are not meant to be used
for anything else but system header files.

*/

typedef unsigned int        __size_t;  /* size of an data object             */
typedef int                __ssize_t;  /* signed version of __size_t         */
typedef unsigned long       __time_t;  /* seconds since 00:00:00 1/1/1970    */
typedef long               __clock_t;  /* system dependent clock ticks       */
typedef unsigned long     __sigset_t;  /* set of signals                     */
typedef unsigned int  __sig_atomic_t;
typedef short                __dev_t;  /* holds (major|minor) device pair    */
typedef char                 __gid_t;  /* group id                           */
typedef unsigned short       __ino_t;  /* i-node number                      */
typedef unsigned short      __mode_t;  /* file type and permissions bits     */
typedef char               __nlink_t;  /* number of links to a file          */
typedef unsigned long        __off_t;  /* offset within a file               */
typedef int                  __pid_t;  /* process id (must be signed)        */
typedef short                __uid_t;  /* user id                            */
typedef long                __zone_t;  /* zone number                        */
typedef long               __block_t;  /* block number                       */
typedef long                 __bit_t;  /* bit number in a bit map            */
typedef unsigned short     __zone1_t;  /* zone number for V1 file systems    */
typedef unsigned short  __bitchunk_t;  /* collection of bits in a bitmap     */
typedef unsigned char         __u8_t;  /* 8 bit type                         */
typedef unsigned short       __u16_t;  /* 16 bit type                        */
typedef unsigned long        __u32_t;  /* 32 bit type                        */
typedef unsigned char         __i8_t;  /* 8 bit signed type                  */
typedef unsigned short       __i16_t;  /* 16 bit signed type                 */
typedef unsigned long        __i32_t;  /* 32 bit signed type                 */
typedef char*              __caddr_t;  /* ?                                  */
typedef void (*__sighandler_t) (int);  /* signal() handler type              */
#if _EM_PSIZE == _EM_WSIZE
typedef int              __ptrdiff_t;  /* result of subtracting two pointers */
#else
typedef long             __ptrdiff_t;
#endif
typedef char               __wchar_t;  /* type expanded character set        */
typedef struct 
{ 
  int quot;
  int rem; 
}                            __div_t;
typedef struct 
{ 
  long quot;
  long rem; 
}                           __ldiv_t;
typedef unsigned short    __tcflag_t;
typedef unsigned char         __cc_t;
typedef unsigned long      __speed_t;

/*

These are kernel specific types, which are usually only needed by the
kernel, device drivers and servers.

*/

#ifdef _MINIX
typedef unsigned int  __vir_clicks_t;  /* virt. addresses/lengths in clicks  */
typedef unsigned long __phys_bytes_t;  /* phys. addresses/lengths in bytes   */
typedef unsigned int __phys_clicks_t;  /* phys. addresses/lengths in clicks  */

#ifndef CHIP
#include <minix/config.h>
#endif

#if (CHIP == INTEL)
typedef unsigned int   __vir_bytes_t;  /* virt. addresses/lengths in bytes   */
#endif
#if (CHIP == M68000)
typedef unsigned long  __vir_bytes_t;  /* virt. addresses/lengths in bytes   */
#endif
#if (CHIP == SPARC)
typedef unsigned long  __vir_bytes_t;  /* virt. addresses/lengths in bytes   */
#endif
#if (CHIP == Tx)
typedef unsigned long  __vir_bytes_t;  /* virt. addresses/lengths in bytes   */
#endif

/* For backwards compatibility, but to be removed soon. */
#define vir_clicks      vir_clicks_t
#define phys_bytes      phys_bytes_t
#define phys_clicks    phys_clicks_t
#define vir_bytes        vir_bytes_t
#define mem_map            mem_map_t

/* Memory segment description                                                */
struct mem_map_t
{
  __vir_clicks_t             mem_vir;  /* virtual start address in clicks    */
  __phys_clicks_t           mem_phys;  /* physical start address in clicks   */
  __vir_clicks_t             mem_len;  /* length of the segment in clicks    */
};

#endif

#endif
