/* $Id: diskparm.h,v 1.1 1994/09/21 16:41:44 stuart Exp $ */

/* Structures relating to disk formats */

#ifndef _DISKPARM_H
#define _DISKPARM_H

#ifdef MACHINE

#if MACHINE == IBM_PC
/* PC (and AT) BIOS structure to hold disk parameters.  Under Minix, it is
 * used mainly for formatting.
 */
struct disk_parameter_s {
  char spec1;
  char spec2;
  char motor_turnoff_sec;
  char sector_size_code;
  char sectors_per_cylinder;
  char gap_length;
  char dtl;
  char gap_length_for_format;
  char fill_byte_for_format;
  char head_settle_msec;
  char motor_start_eigth_sec;
};
#endif

#if MACHINE == TRANSPUTER
/* Transputer (B005) disk information structures.
 */
struct disk_char_s {
  unsigned char drive_type;
  unsigned char sector_size_lg2;
  unsigned char number_of_sectors;
  unsigned char number_of_heads;
  unsigned long number_of_cylinders;
  unsigned char RWC_cylinder_by4;
  unsigned char PC_cylinder_by4;
  unsigned char sector_retries;
  unsigned char seek_retries;
  unsigned char head_step_rate;
  unsigned char head_settle_time;
  unsigned char head_load_time;
  unsigned char motor_start_time;
  unsigned char interleave;
  unsigned char skew;
  unsigned char gap3;
  unsigned char gap4;
  unsigned char num_ecc_correctable_bits;
};

/*
 * Block 0 of a DOS disk (floppy or HD partition)
 */
#define u16 unsigned short
struct block0_s {
	unsigned char	res0[8];
	unsigned char	serial[3];
	unsigned char	bps[2];     /* Bytes per sector */
	unsigned char	spc;        /* Sectors per cluster */
	unsigned char	res[2];     /* Reserved sectors */
	unsigned char	nfats;      /* Number of fats */
	unsigned char	ndirs[2];   /* Size of root directory */
	unsigned char  	nsects[2];  /* Total number of sectors */
	unsigned char	media;      /* Media descriptor */
	unsigned char	spf[2];     /* Secors per fat */
	unsigned char	spt[2];     /* Sectors per track */
	unsigned char	nsides[2];  /* Number of sides */
	unsigned char	nhid[2];    /* Number of hidden files */
	unsigned char	code[0x1e2];
};
#endif /* MACHINE == TRANSPUTER */

#endif /* ifdef MACHINE */

#endif /* _DISKPARM_H */
