/* $Id: boot.h,v 1.3 1995/01/05 14:59:39 stuart Exp $ */

/* boot.h */

#ifndef _BOOT_H
#define _BOOT_H

/* Redefine root and root image devices as variables.
 * This keeps the diffs small but may cause future confusion.
 */
#define BOOT_DEV   (boot_parameters.bp_ramimagedev)
#define ROOT_DEV   (boot_parameters.bp_rootdev)

/* Device numbers of RAM, floppy and hard disk devices.
 * h/com.h defines RAM_DEV but only as the minor number.
 */
#define DEV_FD0   0x200
#define DEV_HD0   0x300
#define DEV_RAM   0x100
#define DEV_SCSI  0x700	/* Atari TT only */

/* Default device numbers for root and root image.
 * Root image is only used when root is /dev/ram.
 */
#define DRAMIMAGEDEV (DEV_FD0 + 0)
#define DROOTDEV     (DEV_FD0 + 0) /* (DEV_RAM + 0) Used to prompt */

/* Default RAM disk size.
 * Not used if root is /dev/ram when size is from root image.
 */
#define DRAMSIZE   0

/* Default scan code to fake a PC keyboard. */
#define DSCANCODE  13

/* Default processor type for no restriction (88 would force 386 to 88). */
#define DPROCESSOR 0xFFFF

/* Structure to hold boot parameters. */
struct bparam_s
{
  dev_t bp_rootdev;
  dev_t bp_ramimagedev;
  unsigned short bp_ramsize;
  unsigned short bp_scancode;		/* still put into BX for kernel */
  unsigned short bp_processor;
};

extern struct bparam_s boot_parameters;

#ifdef MACHINE
#if (MACHINE == TRANSPUTER)
/*
 * Structure which is passed between the boot monitor and the kernel.
 */
typedef enum {
    data_first,
    text_first
} order_t;

typedef struct {
    char name[80];
    char filename[80];
    unsigned short priority;
    int procnum;
    order_t order;
    char args[80];
    unsigned int argc;
    /* Details filled in as module is loaded */
    int data_clicks, text_clicks;
} module_t;
#endif /* (MACHINE == TRANSPUTER) */
#endif /* defined(MACHINE) */

#endif /* _BOOT_H */
