/* $Id: grp.h,v 1.1 1994/09/21 16:41:03 stuart Exp $ */

#ifndef _GRP_H
#define _GRP_H

#include <minix/types.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifdef _POSIX_SOURCE
struct group 
{ 
  char *gr_name;		/* the name of the group */
  char *gr_passwd;		/* the group passwd */
  __gid_t gr_gid;		/* the numerical group ID */
  char **gr_mem;		/* a vector of pointers to the members */
};

struct group *getgrgid(__gid_t _gid);
struct group *getgrnam(const char *_name);
#endif

#ifdef _MINIX
void endgrent(void);
struct group *getgrent(void);
int setgrent(void);
#endif

#ifdef __cplusplus
}
#endif

#endif
