/* $Id: assert.h,v 1.1 1994/09/21 16:41:03 stuart Exp $ */

#ifndef _ASSERT_H
#define _ASSERT_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef NDEBUG
/* Debugging disabled -- do not evaluate assertions. */
#define assert(expr)  ((void) 0)
#else
/* Debugging enabled -- verify assertions at run time. */
#define	__str(x)	#x
#define	__xstr(x)	__str(x)

void __bad_assertion(const char *_mess);

#define	assert(expr)	((expr)? (void)0 : \
				__bad_assertion("Assertion \"" #expr \
				    "\" failed, file " __xstr(__FILE__) \
				    ", line " __xstr(__LINE__) "\n"))
#endif

#ifdef __cplusplus
}
#endif

#endif
