;{{{Lisp}}};{{{ equs
    equ bootLinkIn,0
    equ bootLinkOut,1
    equ netBoot,2
    equ appWPtr,2
    equ neighbourLink,2
    equ length,3
    equ codebuf,4
    equ codebuflen,64
    equ bootbyte,end-memStart
;}}}

    d8 bootbyte
memStart

;{{{ init processor
     ajw     5
     stl     0
     stl     0
     stl     bootLinkIn
     ldl     bootLinkIn
     ldnlp   -4
     stl     bootLinkOut
      
;    Init process queue pointers
     mint
     sthf
     mint
     stlf

;    Init links, event channel and timer queues
     ldc     0
     stl     2
     ldc     11
     stl     3
istart
     mint
     ldl     2
     mint
     wsub
     stnl    0
     ldlp    2
     lend    istart

;    Start timer
     ldc     0
     sttimer

;    Clear error flag and halt on error
     testerr
     sethalterr

#if defined(T800) || defined(T801) || defined(T805)
;    init FPU
     fptesterr
#endif
;}}}
;{{{ FEP specific SS reset
#ifdef FEP
; enable SS reset also to reset communication transputer
    ldc 2
    ldc 0x40000000
    stnl 0
; deassert analyse
    ldc 0
    ldc 0x00000004
    stnl 0
; deassert reset
    ldc 0
    ldc 0x00000000
    stnl 0
; assert reset
    ldc 1
    ldc 0x00000000
    stnl 0
    ldtimer
    ldc 156
    sum
    tin
; deassert reset
    ldc 0
    ldc 0x00000000
    stnl 0
#endif
;}}}

;{{{ request:4                -- 0==appBoot, 1==forwardMsg
boot_loop
     ldlp netBoot
     ldl bootLinkIn
     ldc 4
     in
     ldl netBoot
     cj appBoot
;}}}

;{{{ link:4 len:4 code:len    -- forwardMsg
;{{{ get link address
     ldlp neighbourLink
     ldl bootLinkIn
     ldc 4
     in
     ldl neighbourLink
     ldc 2
     shl
     mint
     sum
     stl neighbourLink
;}}}
;{{{ get code length
     ldlp length
     ldl bootLinkIn
     ldc 4
     in
;}}}
;{{{ get code:len from bootLinkIn and send it to neighbourLink
loop
;    if (length<=64) goto loopexit
     ldl length
     ldc codebuflen
     gt
     cj loopexit
;    in(&codebuf,bootLinkIn,codebuflen)
     ldlp codebuf
     ldl bootLinkIn
     ldc codebuflen
     in
;    out(&codebuf,neighbourLink,codebuflen)
     ldlp codebuf
     ldl neighbourLink
     ldc codebuflen
     out
;    length-=codebuflen
     ldl length
     equ negcodebuflen,-codebuflen
     adc negcodebuflen
     stl length
     j loop
loopexit
;    if (length==0) goto done
     ldl length
     cj done
     ldlp codebuf
     ldl bootLinkIn
     ldl length
     in
     ldlp codebuf
     ldl neighbourLink
     ldl length
     out
done
;}}}
    j boot_loop
;}}}

;{{{ memSize:4 proc:4 len:4 code:len -- appBoot
appBoot
;{{{ get memSize and compute application WPtr
     ldlp appWPtr
     ldl bootLinkIn
     ldc 4
     in
     ldl appWPtr
     mint
     sum
     ldnlp -5
     stl appWPtr
;}}}
;{{{ put bootLinkIn and bootLinkOut at appWPtr loc 1,2
     ldl bootLinkIn
     ldl appWPtr
     stnl 1
     ldl bootLinkOut
     ldl appWPtr
     stnl 2
;}}}
;{{{ get proc at stack loc 3
    ldl appWPtr
    ldnlp 3
    ldl bootLinkIn
    ldc 4
    in
;}}}
;{{{ get code length at stack loc 4
    ldl appWPtr
    ldnlp 4
    ldl bootLinkIn
    ldc 4
    in
;}}}
;{{{ move code loader under end of appWPtr and start it
     equ loadlen,loadend-loadstart
;    there must be 5 free words under WPtr (20 byte)
     equ negloadlen,-(loadlen+20)
     ldpi loadstart
     ldl appWPtr
     adc negloadlen
     ldc loadlen
     move
     ldl appWPtr
     adc negloadlen
     gcall
;}}}
;{{{ code loader
    align
loadstart
    ldl appWPtr
    gajw
    equ c,memStart-0x80000000
    mint
    adc c
    ldl 1
    ldl 4
    in
    mint
    adc c
    gcall
loadend
;}}}
;}}}
end
