/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#ifdef _XOPEN_SOURCE
#include <nl_types.h>
#else
typedef long nl_catd;
static nl_catd catopen(char *name, int oflag) { return 0; }
static char *catgets(nl_catd catd, int set_id, int msg_id, char *msg) { return msg; }
static void catclose(nl_catd catd) { }
#endif

#include <a.out.h>

#include <sys/types.h>
#include <assert.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
/*}}}  */

/*{{{  main*/
int main(int argc, char *argv[])
{
  /*{{{  variables*/
  int usage=0;
  int ex=0;
  int c;
  nl_catd catd;
  /*}}}  */

  /*{{{  set locale*/
  setlocale(LC_ALL,"");
  catd=catopen("strip",0);
  /*}}}  */
  /*{{{  parse arguments*/
  while ((c=getopt(argc,argv,"h?"))!=EOF)
  switch (c)
  {
    /*{{{  h, ?*/
    case 'h':
    case '?':
    {
      usage=1;
      break;
    }
    /*}}}  */
  }
  /*{{{  open input file*/
  if (optind>=argc) usage=1;
  /*}}}  */
  /*}}}  */
  /*{{{  check usage*/
  if (usage)
  {
    fprintf(stderr,catgets(catd,1,1,"Usage: strip file ...\n"));
    exit(1);
  }
  /*}}}  */
  for (; optind<argc; ++optind)
  {
    /*{{{  variables*/
    int fdr;
    /*}}}  */

    if ((fdr=open(argv[optind],O_RDONLY))<0)
    /*{{{  complain*/
    {
      fprintf(stderr,catgets(catd,1,2,"strip: %s: %s\n"),argv[optind],strerror(errno));
      ex=1;
    }
    /*}}}  */
    else
    /*{{{  go ahead*/
    {
      /*{{{  variables*/
      struct exec a_out;
      off_t len;
      /*}}}  */

      if (read(fdr,&a_out,A_MINHDR)!=A_MINHDR)
      /*{{{  complain*/
      {
        fprintf(stderr,catgets(catd,1,3,"strip: can't read header of %s\n"),argv[optind]);
        ex=1;
      }
      /*}}}  */
      else
      {
        if (BADMAG(a_out))
        /*{{{  complain*/
        {
          fprintf(stderr,catgets(catd,1,4,"strip: %s is not in a.out format\n"),argv[optind]);
          ex=1;
        }
        /*}}}  */
        else
        {
          if (a_out.a_hdrlen>A_MINHDR) read(fdr,&(a_out.a_trsize),a_out.a_hdrlen-A_MINHDR);
          len=a_out.a_text+a_out.a_data;
          if (a_out.a_hdrlen>A_MINHDR) { len+=a_out.a_trsize; len+=a_out.a_drsize; }
          if (a_out.a_syms==0) fprintf(stderr,catgets(catd,1,5,"strip: %s is already stripped\n"),argv[optind]);            
          else
          /*{{{  strip*/
          {
            /*{{{  variables*/
            char tmp[_POSIX_PATH_MAX];
            char buffer[1024];
            off_t blocks=len/sizeof(buffer);
            int fdw;
            /*}}}  */

            if (strrchr(argv[optind],'/')==(char*)0) strcpy(tmp,"stripXXXXXX");
            else { strcpy(tmp,argv[optind]); strcpy(strrchr(tmp,'/')+1,"stripXXXXXX"); }
            mktemp(tmp);
            if ((fdw=open(tmp,O_WRONLY|O_CREAT|O_EXCL,0666))<0)
            {
              fprintf(stderr,catgets(catd,1,6,"strip: can not create temporary file %s\n"),tmp);
              ex=1;
            }
            else
            {
              a_out.a_syms=0;
              write(fdw,&a_out,a_out.a_hdrlen);
              while (blocks>0)
              {
                read(fdr,&buffer,sizeof(buffer));
                write(fdw,&buffer,sizeof(buffer));
                --blocks;
              } 
              if (len%sizeof(buffer))
              {
                read(fdr,&buffer,len%sizeof(buffer));
                write(fdw,&buffer,len%sizeof(buffer));
              }
              if (lseek(fdw,(off_t)0,SEEK_CUR)!=len+a_out.a_hdrlen)
              {
                fprintf(stderr,catgets(catd,1,7,"strip: can not write unstripped file %s\n"),tmp);
                unlink(tmp);
                ex=1;
              }
              else rename(tmp,argv[optind]);
              close(fdw);
            }  
          }
          /*}}}  */
        }
      }
      close(fdr);
    }
    /*}}}  */
  }
  return ex;
}
/*}}}  */
