/*{{{}}}*/
/*{{{  #includes*/
#undef _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <a.out.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "../common/buf.h"
#include "../common/error.h"
#include "../common/common.h"
#include "symbol.h"
#include "main.h"
/*}}}  */
/*{{{  #defines*/
#define mystrcmp(s,r) (*(s)-*(r) ? *(s)-*(r) : strcmp((s)+1,(r)+1))
#define AVL
/*}}}  */

/*{{{  type definitions*/
typedef struct Table
{
  struct Table *left, *right;
  char *symbol;
  unsigned long value;
  int bal;
  int defined;
} Table;
/*}}}  */

/*{{{  variable declarations*/
private Table *table=(Table*)0;
/*}}}  */
/*{{{  print_symbol*/
private char *print_symbol(char *s)
{
  static char sym[40+SYMBOL_LENGTH];

  if (s[0]=='\1' && s[1]=='\1') return (s+2);
  sprintf(sym,"<private symbol %d,%d> %s",(unsigned int)((unsigned char)s[0]),(unsigned int)((unsigned char)s[1]),s+2);
  return sym;
}
/*}}}  */
#ifdef AVL
/*{{{  search*/
/*{{{  Notes*/
/*

Niklaus Wirth, Algorithmen und Datenstrukturen mit Modula-2, p. 228-229

*/
/*}}}  */
private void search(char *s, unsigned long value, Table **p, Bool *h, int defined)
{
  /*{{{  variables*/
  Table *p1,*p2;
  int rel;
  /*}}}  */

  if ((*p)==(Table*)0)
  /*{{{  insert*/
  {
    (*p)=xmalloc(sizeof(Table));
    (*h)=TRUE;
    (*p)->symbol=strcpy(xmalloc(strlen(s)+1),s);
    (*p)->value=value;
    (*p)->left=(Table*)0;
    (*p)->right=(Table*)0;
    (*p)->bal=0;
    (*p)->defined=defined;
  }
  /*}}}  */
  else if ((rel=mystrcmp((*p)->symbol,s))>0)
  {
    search(s,value,&((*p)->left),h,defined);
    if (*h)
    /*{{{  left branch has grown*/
    {
      switch ((*p)->bal)
      {
        case 1: (*p)->bal=0; (*h)=FALSE; break;
        case 0: (*p)->bal=-1; break;
        case -1:
        /*{{{  rebalance*/
        {
          p1=(*p)->left;
          if (p1->bal==-1)
          /*{{{  single LL rotation*/
          {
            (*p)->left=p1->right;
            p1->right=(*p);
            (*p)->bal=0;
            (*p)=p1;
          }
          /*}}}  */
          else
          /*{{{  double LR rotation*/
          {
            p2=p1->right;
            p1->right=p2->left;
            p2->left=p1;
            (*p)->left=p2->right;
            p2->right=(*p);
            if (p2->bal==-1) (*p)->bal=1; else (*p)->bal=0;
            if (p2->bal==1) p1->bal=-1; else p1->bal=0;
            (*p)=p2;
          }
          /*}}}  */
          (*p)->bal=0;
          (*h)=FALSE;
          break;
        }
        /*}}}  */
      }
    }
    /*}}}  */
  }
  else if (rel<0)
  {
    search(s,value,&((*p)->right),h,defined);
    if (*h)
    /*{{{  right branch has grown*/
    {
      switch ((*p)->bal)
      {
        case -1: (*p)->bal=0; (*h)=FALSE; break;
        case 0: (*p)->bal=1; break;
        case 1:
        /*{{{  rebalance*/
        {
          p1=(*p)->right;
          if (p1->bal==1)
          /*{{{  single RR rotation*/
          {
            (*p)->right=p1->left;
            p1->left=(*p);
            (*p)->bal=0;
            (*p)=p1;
          }
          /*}}}  */
          else
          /*{{{  double RL rotation*/
          {
            p2=p1->left;
            p1->left=p2->right;
            p2->right=p1;
            (*p)->right=p2->left;
            p2->left=(*p);
            if (p2->bal==1) (*p)->bal=-1; else (*p)->bal=0;
            if (p2->bal==-1) p1->bal=1; else p1->bal=0;
            (*p)=p2;
          }
          /*}}}  */
          (*p)->bal=0;
          (*h)=FALSE;
          break;
        }
        /*}}}  */
      }
    }
    /*}}}  */
  }
  else error("ld: multiple defined symbol %s",print_symbol(s),"");
}
/*}}}  */
#endif

/*{{{  add_symbol*/
public void add_symbol(char *s, unsigned long v, int defined)
{
#ifndef AVL
  Table **p= &table;
  int cmp;

  while (*p!=(Table*)0)
  {
    cmp=mystrcmp(s,(*p)->symbol);
    if (cmp<0) p=&((*p)->left);
    else if (cmp==0) 
    { 
      error("ld: multiple defined symbol %s",print_symbol(s),""); 
      return; 
    }
    else p=&((*p)->right);
  }
  *p=xmalloc(sizeof(Table));
  (*p)->left = (*p)->right = (Table*)0;
  (*p)->symbol=strcpy(xmalloc(strlen(s)+1),s);
  (*p)->value=v;
  (*p)->defined=defined;
#else
  Bool h;

  search(s,v,&table,&h,defined);
#endif
}
/*}}}  */
/*{{{  update_symbol*/
public Bool update_symbol(char *s, unsigned long v, int defined)
{
  Table **p= &table;
  int cmp;
  char *q;

  while
  /*{{{  (*p)!=(Table*)0 && cmp=strcmp((*p)->symbol,s)*/
  (
    *p!=(Table*)0 &&
    (
      (q=(*p)->symbol,cmp=*s-*q)
      ? cmp
      :
      (
        (cmp=*(s+1)-*(q+1))
        ? cmp
        : (cmp=strcmp(s+2,q+2))
      )
    )
  )
  /*}}}  */
  p=(cmp<0 ? &((*p)->left) : &((*p)->right));
  if ((*p)->value!=v || !defined)
  {
    (*p)->value=v;
    (*p)->defined=defined;
    return TRUE;
  }
  else return FALSE;
}
/*}}}  */
/*{{{  get_symbol*/
public Bool get_symbol(char *s, unsigned long *v, int pass, int *defined)
{
  Table **p= &table;
  int cmp;
  char *q;

  while
  /*{{{  */
  (
    *p!=(Table*)0 &&
    (
      (q=(*p)->symbol,cmp=*s-*q)
      ? cmp
      :
      (
        (cmp=*(s+1)-*(q+1))
        ? cmp
        : (cmp=strcmp(s+2,q+2))
      )
    )
  )
  /*}}}  */
  p=(cmp<0 ? &((*p)->left) : &((*p)->right));
  if (*p)
  {
    *v=(*p)->value;
    *defined=(*p)->defined;
    return TRUE;
  }
  else
  {
    if (pass>1) error("ld: undefined symbol %s",print_symbol(s),"");
    *defined=0;
    return FALSE;
  }
}
/*}}}  */
/*{{{  dump_table*/
private void dump(Table *p, FILE *fp)
{
  char *s;

  if (p)
  {
    dump(p->left,fp);
    s=print_symbol(p->symbol);
    if (*s) fprintf(fp,"%s %lx\n",s,p->value);
    dump(p->right,fp);
  }
}

public void dump_table(FILE *fp)
{
  dump(table,fp);
}
/*}}}  */
/*{{{  size_table*/
private int size(Table *p)
{
  if (p) return (size(p->left)+size(p->right)+(p->symbol[0]=='\1' && p->symbol[1]=='\1'));
  else return 0;
}

public int size_table(void)
{
  return size(table);
}
/*}}}  */
/*{{{  hdr_table*/
private void hdr(Table *p)
{
  struct nlist entry;
  const char *e;
  int n;

  if (p)
  {
    hdr(p->left);
    if (p->symbol[0]=='\1' && p->symbol[1]=='\1')
    {
      strncpy(entry.n_name,p->symbol+2,8);
      entry.n_value=p->value;
      entry.n_sclass=C_STAT|N_TEXT;
      entry.n_numaux=0;
      entry.n_type=0;
      e=(const char*)&entry;
      for (n=0; n<sizeof(entry); ++n) { buf_putc(*e); ++e; }
    }
    hdr(p->right);
  }
}

public void hdr_table(void)
{
  hdr(table);
}
/*}}}  */

