/*{{{}}}*/
/*{{{  #includes*/
#undef _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#ifdef _XOPEN_SOURCE
#include <nl_types.h>
#else
typedef long nl_catd;
static nl_catd catopen(char *name, int oflag) { return 0; }
static char *catgets(nl_catd catd, int set_id, int msg_id, char *msg) { return msg; }
static void catclose(nl_catd catd) { }
#endif

#include <a.out.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <limits.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "../common/common.h"
#include "../common/buf.h"
#include "../common/number.h"
#include "../common/error.h"
#include "lk.h"
#include "ld.h"
/*}}}  */
/*{{{  #defines*/
#define TMPFILE   "/tmp/ldXXXXXX"
/*}}}  */

/*{{{  variables*/
unsigned long startpc=0x8FFFFFFFU;
char infile[_POSIX_PATH_MAX]=TMPFILE;
int nolengths=0;
char outfile[_POSIX_PATH_MAX];
char symfile[_POSIX_PATH_MAX];
int nosym=0;
Bool usage=FALSE, short_a_out=FALSE, long_a_out=FALSE;
int verbose=0;
int num_reloc=0;
unsigned long chmem=4096;
char architecture[]="800";
/*}}}  */

/*{{{  sigterm*/
static void sigterm(int n)
{
  unlink(infile);
  unlink(*outfile ? outfile : OUTFILE);
  exit(1);
}
/*}}}  */
/*{{{  xmalloc*/
void *xmalloc(size_t n)
{
  void *p=malloc(n);

  if (p==(void*)0)
  {
    fprintf(stderr,"ld: out of memory *cry*\n");
    exit(127);
  }
  return p;
}
/*}}}  */

/*{{{  main*/
int main(int argc, char *argv[])
{
  /*{{{  variables*/
  int c;
  Bool usage=FALSE,bootflag=FALSE;
  FILE *tmpfp;
  int a_unused=A_TP_MBS|A_TP_FPU|A_TP_EXTRAINST;
  /*}}}  */

  /*{{{  parse arguments*/
  *outfile='\0';
  *symfile='\0';
  while ((c=getopt(argc,argv,"c:mMa:vo:S:bT:s?"))!=EOF) switch (c)
  {
    /*{{{  v*/
    case 'v': ++verbose; break;
    /*}}}  */
    /*{{{  h,?*/
    case 'h':
    case '?': usage=TRUE; break;
    /*}}}  */
    /*{{{  o*/
    case 'o':
    {
      strcpy(outfile,optarg);
      break;
    }
    /*}}}  */
    /*{{{  S file*/
    case 'S':
    {
      strcpy(symfile,optarg);
      break;
    }
    /*}}}  */
    /*{{{  a address*/
    case 'a':
    {
      char *endptr;
    
      startpc=number(optarg,&endptr);
      if (endptr==optarg) fatal(2,"ld: Invalid start address %s",optarg);
      break;
    }
    /*}}}  */
    /*{{{  c value*/
    case 'c':
    {
      char *endptr;
    
      chmem=number(optarg,&endptr);
      if (endptr==optarg) fatal(2,"ld: Invalid chmem value %s",optarg);
      break;
    }
    /*}}}  */
    /*{{{  m*/
    case 'm':
    {
      short_a_out=TRUE;
      long_a_out=FALSE;
      startpc=0;
      break;
    }
    /*}}}  */
    /*{{{  M*/
    case 'M':
    {
      long_a_out=TRUE;
      short_a_out=FALSE;
      startpc=0;
      break;
    }
    /*}}}  */
    /*{{{  b*/
    case 'b': bootflag=TRUE; break;
    /*}}}  */
    /*{{{  T 400|414|425|800|801|805*/
    case 'T':
    {
      if (!strcmp("400",optarg)) a_unused=A_TP_MBS|A_TP_FPSUPPORT|A_TP_EXTRAINST|A_TP_DBGSUPPORT;
      else if (!strcmp("414",optarg)) 
      {
        a_unused=A_TP_MBS|A_TP_FPSUPPORT;
        if (startpc==0x8FFFFFFFU) startpc=0x80000048U;
      }  
      else if (!strcmp("425",optarg)) a_unused=A_TP_MBS|A_TP_FPSUPPORT|A_TP_EXTRAINST|A_TP_DBGSUPPORT;
      else if (!strcmp("800",optarg)) a_unused=A_TP_MBS|A_TP_FPU|A_TP_EXTRAINST;
      else if (!strcmp("801",optarg)) a_unused=A_TP_MBS|A_TP_FPU|A_TP_EXTRAINST|A_TP_DBGSUPPORT;
      else if (!strcmp("805",optarg)) a_unused=A_TP_MBS|A_TP_FPU|A_TP_EXTRAINST|A_TP_DBGSUPPORT;  
      else usage=TRUE;
      if (!usage) strcpy(architecture,optarg);
      break;
    }
    /*}}}  */
    /*{{{  s*/
    case 's': nosym=1; break;
    /*}}}  */
  }
  if (startpc==0x8FFFFFFFU) startpc=0x80000070U;
  if (bootflag) --startpc;
  if (optind>=argc) usage=TRUE;
  if (usage)
  {
    fprintf(stderr,"Usage: ld [-v][-m|-M][-b][-s][-o outputfile][-S symboltable][-a address]\n");
    fprintf(stderr,"          [-T 400|414|425|800|801|805][-c chmem] objectfile|library|-llibrary ...\n");
    exit(1);
  }
  /*}}}  */
  signal(SIGHUP,sigterm);
  signal(SIGINT,sigterm);
  signal(SIGQUIT,sigterm);
  signal(SIGTERM,sigterm);
  mktemp(infile);
  if ((out=buf_open(infile,O_WRONLY|O_CREAT|O_TRUNC,0666))<0) fatal(1,"ld: can't open temporary file %s\n",infile);
  lk(argc-optind,argv+optind);
  buf_close();
  if ((tmpfp=fopen(infile,"rb"))==(FILE*)0) fatal(1,"ld: can't open tmp file %s",infile);
  ld(tmpfp,a_unused);
  fclose(tmpfp);
  unlink(infile);
  if (short_a_out || long_a_out) chmod(outfile,0777 & ~umask(0));
  return 0;
}
/*}}}  */
