/*{{{}}}*/
/*{{{  Notes*/
/*

Warning: when extending the linker, be aware of its structure: It first
reads all object modules for finding out which symbols are used and
exported, then it makes a second run with concatenating all needed
modules.  Extending only code for the first pass is not enough!

*/
/*}}}  */
/*{{{  #includes*/
#undef _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <sys/types.h>
#include <ar.h>
#include <assert.h>
#include <unistd.h>
#include <limits.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "../common/common.h"
#include "../common/buf.h"
#include "../common/getputlong.h"
#include "../common/error.h"
#include "main.h"
/*}}}  */

/*{{{  types*/
/*{{{  structure for used symbols*/
typedef struct Symbol
{
  char *name;
  struct Symbol *next;
} Symbol;

typedef struct
{
  Symbol *list;
  Bool used;
  Bool processed;
  Bool dontuse;
  char *name;
} Module;
/*}}}  */
/*{{{  structure for public symbols*/
typedef struct Symbolnode
{
  char *name;
  struct Symbolnode *left,*right;
  int module;
} Symbolnode;
/*}}}  */
/*}}}  */
/*{{{  variables*/
private Module module[MODULE_NUMBER];
private Symbolnode *root;
private unsigned char mod1='\1', mod2='\2';
/*}}}  */

int myfread(void *p,int sz,int n,FILE *fp);
#define fread myfread

/*{{{  library     -- convert x (from -lx) into library path*/
char *library(char *name)
{
  char *s=xmalloc(32+strlen(name));

  strcpy(s,"/usr/lcc/lib.T");
  strcat(s,architecture);
  strcat(s,"/lib");
  strcat(s,name);
  strcat(s,".a");
  return s;
}
/*}}}  */
/*{{{  note_public -- note exported symbol in symbol table*/
private int note_public(char *symbol, int number)
{
  if (symbol!=(char*)0)
  {
    Symbolnode **p= &root;
    int cmp;

    while (*p!=(Symbolnode*)0)
    {
      cmp=strcmp(symbol,(*p)->name);
      if (cmp<0) p=&((*p)->left);
      else if (cmp==0)
      {
        fprintf(stderr,"ld: warning: symbol %s defined in module %s and in module %s\n",symbol,module[(*p)->module].name,module[number].name);
        return 1;
      }
      else p=&((*p)->right);
    }
    *p=xmalloc(sizeof(Symbolnode));
    (*p)->left = (*p)->right = (Symbolnode*)0;
    (*p)->name=strcpy(xmalloc(strlen(symbol)+1),symbol);
    (*p)->module=number;
  }
  return 0;
}
/*}}}  */
/*{{{  free_public -- free symbol table of public symbols*/
static void free_public(Symbolnode *p)
{
  if (p)
  {
    free_public(p->left);
    free_public(p->right);
    free(p->name);
    free(p);
  }
}
/*}}}  */
/*{{{  note_used   -- note used symbol in module entry*/
private void note_used(char *symbol, int number)
{
  if (symbol!=(char*)0)
  {
    Symbol *old;

    old=module[number].list;
    module[number].list=xmalloc(sizeof(Symbol));
    module[number].list->next=old;
    module[number].list->name=strcpy(xmalloc(strlen(symbol)+1),symbol);
  }
}
/*}}}  */
/*{{{  free_used   -- free symbol table of used symbols in a module*/
static void free_used(Module *module, int modules)
{
  for (; modules>0; --modules,++module)
  {
    Symbol *list;

    free(module->name);
    list=module->list;
    while (list)
    {
      Symbol *next;

      free(list->name);
      next=list->next;
      free(list);
      list=next;
    }
  }
}
/*}}}  */
/*{{{  get_char    -- get character and decrement archive element length*/
private int get_char(FILE *fp, off_t *len)
{
  --(*len);
  return(fgetc(fp));
}
/*}}}  */
/*{{{  conv_symbol -- convert a private symbol into a unique public symbol*/
private void conv_symbol(FILE *infp, off_t *len)
{
  /*{{{  variable declarations*/
  int c;
  /*}}}  */

  ++nolengths;
  if ((c=get_char(infp,len))=='@')
  /*{{{  create unique symbol name*/
  {
    buf_putc(mod1);
    buf_putc(mod2);
  }
  /*}}}  */
  else
  /*{{{  write public number*/
  {
    buf_putc('\1');
    buf_putc('\1');
    buf_putc(c);
  }
  /*}}}  */
  /*{{{  copy rest of name*/
  {
    int c;

    while ((c=get_char(infp,len))) buf_putc(c); 
    buf_putc('\0');
  }
  /*}}}  */
}
/*}}}  */
/*{{{  read_symbol -- read symbol from object file*/
private char *read_symbol(FILE *infp, off_t *len)
{
  /*{{{  variable declarations*/
  static char name[SYMBOL_LENGTH],*p;
  int c;
  /*}}}  */

  p=name;
  if ((c=get_char(infp,len))=='@')
  /*{{{  skip private module and return nothing*/
  {
    while (get_char(infp,len));
    return (char*)0; 
  }
  /*}}}  */
  else
  /*{{{  return symbol*/
  {
    *p++=c;
    while ((*p++=get_char(infp,len)));
    return name;
  }
  /*}}}  */
}
/*}}}  */

/*{{{  lk*/
void lk(int argc, char *argv[])
{
  /*{{{  variable declarations*/
  FILE *infp;
  int tag;
  int i,number=0;
  Bool working;
  char magic[SARMAG];
  Bool is_archive;
  off_t ar_len;
  struct ar_hdr header;
  Bool padding;
  char codebuf[255];
  int codebuflen=0;
  /*}}}  */

  /*{{{  read information from modules*/
  number=0;
  for (i=0; i<argc; i++)
  {
    if (strncmp(argv[i],"-l",2)==0) argv[i]=library(argv[i]+2);
    if ((infp=fopen(argv[i],"rb"))==(FILE*)0)
    /*{{{  complain*/
    {
      error("ld: can't open objectfile %s",argv[i],"");
      exit(1);
    }
    /*}}}  */
    /*{{{  determine file type (object module, ar archive)*/
    if (!(is_archive=((fread(magic,SARMAG,1,infp)==1) && !strncmp(magic,ARMAG,SARMAG)))) fseek(infp,(off_t)0,SEEK_SET);
    /*}}}  */
    do
    /*{{{  process module*/
    {
      /*{{{  init module information*/
      if (is_archive)
      {
        char *p=header.ar_name+sizeof(header.ar_name);

        if (fread(&header,sizeof(header),1,infp)!=1) break;
        while (--p!=&(header.ar_name[0])) if (*p=='/') { *p='\0'; break; }
        ar_len=atol(header.ar_size);
        padding=(ar_len&1);
        if (strncmp(header.ar_fmag,ARFMAG,sizeof(header.ar_fmag)))
        {
          error("ld: bad magic number in archive %s during pass 1",argv[i],"");
          exit(1);
        }
        module[number].name=strcpy(xmalloc(strlen(header.ar_name)+1),header.ar_name);
        module[number].used=FALSE;
        module[number].dontuse=FALSE;
      }
      else
      {
        padding=FALSE;
        module[number].name=strcpy(xmalloc(strlen(argv[i])+1),argv[i]);
        module[number].used=TRUE;
        module[number].dontuse=FALSE;
      }
      module[number].list=(Symbol*)0;
      module[number].processed=FALSE;
      /*}}}  */
      tag=LABEL; /* has to be something != EOF in case module is empty */
      while (is_archive ? ar_len>0 && (tag=get_char(infp,&ar_len))!=EOF : (tag=get_char(infp,&ar_len))!=EOF)
      /*{{{  process record*/
      {
        switch (tag)
        {
          /*{{{  ALIGN*/
          case ALIGN: break;
          /*}}}  */
          /*{{{  RELOCATE*/
          case RELOCATE: break;
          /*}}}  */
          /*{{{  CODE*/
          case CODE:
          {
            int len;

            len=get_char(infp,&ar_len);
            while (len--) get_char(infp,&ar_len);
            break;
          }
          /*}}}  */
          /*{{{  EQU*/
          case EQU:
          {
            char *s=read_symbol(infp,&ar_len);

            if (module[number].dontuse==FALSE && note_public(s,number)) module[number].dontuse=TRUE;
            if (module[number].used==TRUE) module[number].dontuse=FALSE;
            while ((tag=get_char(infp,&ar_len))!=EOF && tag!=ENDEQU)
            {
              switch (tag)
              {
                /*{{{  SYMBOL*/
                case SYMBOL:
                {
                  note_used(read_symbol(infp,&ar_len),number);
                  break;
                }
                /*}}}  */
                /*{{{  NUMBER*/
                case NUMBER:
                {
                  unsigned long value;

                  value=getlong(infp);
                  ar_len-=sizeof(value);
                  break;
                }
                /*}}}  */
                /*{{{  default*/
                default: break;
                /*}}}  */
              }
            }
            break;
          }
          /*}}}  */
          /*{{{  LABEL*/
          case LABEL:
          {
            char *s=read_symbol(infp,&ar_len);
            
            if (module[number].dontuse==FALSE && note_public(s,number)) module[number].dontuse=TRUE;
            if (module[number].used==TRUE) module[number].dontuse=FALSE;
            break;
          }
          /*}}}  */
          /*{{{  DS*/
          case DS:
          {
            getlong(infp); ar_len-=sizeof(long);
            break;
          }
          /*}}}  */
          /*{{{  default*/
          default:
          {
            assert(tag<LAST_TAG);
            note_used(read_symbol(infp,&ar_len),number);
            break;
          }
          /*}}}  */
        }
      }
      /*}}}  */
      if (padding) tag=fgetc(infp);
      number++;
    }
    /*}}}  */
    while (tag!=EOF);
    fclose(infp);
  }
  /*}}}  */
  /*{{{  determine needed modules*/
  do
  {
    /*{{{  variables*/
    Symbol *run;
    /*}}}  */

    working=FALSE;
    for (i=0; i<number; i++) if (module[i].used && !module[i].processed)
    /*{{{  process module and mark all directly needed modules*/
    {
      if (module[i].dontuse==FALSE)
      {
      module[i].processed=TRUE;
      for (run=module[i].list; run!=(Symbol*)0; run=run->next)
      {
        Symbolnode **p=&root;
        int cmp;

        while (*p!=(Symbolnode*)0 && (cmp=strcmp(run->name,(*p)->name)))
        {
          if (cmp<0) p=&((*p)->left);
          else p=&((*p)->right);
        }
        if (*p==(Symbolnode*)0) error("ld: symbol %s referenced by module %s but not found",run->name,module[i].name);
        else if (!module[(*p)->module].used)
        {
          module[(*p)->module].used=TRUE;
          working=TRUE;
        }
      }
      }
      else fprintf(stderr,"module %s not used\n",module[i].name);
    }
    /*}}}  */
  }
  while (working);
  /*}}}  */
  /*{{{  concatenate needed modules*/
  number=0;
  for (i=0; i<argc; i++)
  {
    infp=fopen(argv[i],"rb");
    /*{{{  determine file type (object module, ar archive)*/
    if (!(is_archive=((fread(magic,SARMAG,1,infp)==1) && !strncmp(magic,ARMAG,SARMAG)))) fseek(infp,(off_t)0,SEEK_SET);
    /*}}}  */
    do
    /*{{{  process module*/
    {
      /*{{{  init module information*/
      if (is_archive)
      {
        char *p=header.ar_name+sizeof(header.ar_name);

        if (fread(&header,sizeof(header),1,infp)!=1) break;
        while (--p!=&(header.ar_name[0])) if (*p=='/') { *p='\0'; break; }
        ar_len=atol(header.ar_size);
        padding=(ar_len&1);
        if (strncmp(header.ar_fmag,ARFMAG,sizeof(header.ar_fmag)))
        {
          error("ld: bad magic number in archive %s, module %s during pass 2",argv[i],header.ar_name);
          exit(1);
        }
      }
      else padding=FALSE;
      /*}}}  */
      if (verbose>1 && module[number].used) fprintf(stderr,"ld: module %s %d,%d\n",module[number].name,mod1,mod2);
      tag=LABEL;
      while (is_archive ? ar_len>0 && (tag=get_char(infp,&ar_len))!=EOF : (tag=get_char(infp,&ar_len))!=EOF) if (module[number].used)
      /*{{{  process record*/
      {
        if (tag!=CODE)
        /*{{{  empty codebuffer if any, and write tag after*/
        {
          if (codebuflen)
          /*{{{  empty code buffer*/
          {
            char *p=codebuf;

            buf_putc(CODE);
            buf_putc(codebuflen);
            while (codebuflen>0) { buf_putc(*p); ++p; --codebuflen; }
            codebuflen=0;
          }
          /*}}}  */
          buf_putc(tag);
        }
        /*}}}  */
        switch (tag)
        {
          /*{{{  ALIGN*/
          case ALIGN: break;
          /*}}}  */
          /*{{{  RELOCATE*/
          case RELOCATE: ++num_reloc; break;
          /*}}}  */
          /*{{{  CODE*/
          case CODE:
          {
            int len;
            int res;

            len=get_char(infp,&ar_len);
            if ((codebuflen+len)>sizeof(codebuf))
            /*{{{  empty code buffer first*/
            {
              char *p=codebuf;

              buf_putc(CODE);
              buf_putc(codebuflen);
              while (codebuflen>0) { buf_putc(*p); ++p; --codebuflen; }
            }
            /*}}}  */
            res=fread(codebuf+codebuflen,len,1,infp);
            assert(res==1);
            ar_len-=len;
            codebuflen+=len;
            break;
          }
          /*}}}  */
          /*{{{  EQU*/
          case EQU:
          {
            conv_symbol(infp,&ar_len);
            while ((tag=get_char(infp,&ar_len))!=EOF && tag!=ENDEQU)
            {
              buf_putc(tag);
              switch (tag)
              {
                /*{{{  SYMBOL*/
                case SYMBOL:
                {
                  conv_symbol(infp,&ar_len);
                  break;
                }
                /*}}}  */
                /*{{{  NUMBER*/
                case NUMBER:
                {
                  buf_putc(fgetc(infp));
                  buf_putc(fgetc(infp));
                  buf_putc(fgetc(infp));
                  buf_putc(fgetc(infp));
                  ar_len-=4;
                  break;
                }
                /*}}}  */
                /*{{{  default*/
                default: break;
                /*}}}  */
              }
            }
            buf_putc(ENDEQU);
            break;
          }
          /*}}}  */
          /*{{{  DS*/
          case DS:
          {
            buf_putc(fgetc(infp));
            buf_putc(fgetc(infp));  
            buf_putc(fgetc(infp));  
            buf_putc(fgetc(infp));
            ar_len-=4;
            break;
          }
          /*}}}  */
          /*{{{  default*/
          default: assert(tag<LAST_TAG); conv_symbol(infp,&ar_len); break;
          /*}}}  */
        }
      }
      /*}}}  */
      if (padding) tag=fgetc(infp);
      ++number;
      /*{{{  increment object file number*/
      mod2++;
      if (mod2=='@') mod2++;
      else if (mod2==127) { mod2='\1'; mod1++; }
      if (mod1=='@') mod1++;
      /*}}}  */
    }
    /*}}}  */
    while (tag!=EOF);
    fclose(infp);
  }
  if (codebuflen)
  /*{{{  empty code buffer*/
  {
    char *p=codebuf;

    buf_putc(CODE);
    buf_putc(codebuflen);
    while (codebuflen>0) { buf_putc(*p); ++p; --codebuflen; }
  }
  /*}}}  */
  /*}}}  */
  /*{{{  free memory used for module information*/
  free_public(root);
  free_used(module,number);
  /*}}}  */
}
/*}}}  */
