/*{{{}}}*/
/*{{{  #includes*/
#undef _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <sys/types.h>
#include <a.out.h>
#include <assert.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "../common/getputlong.h"
#include "../common/error.h"
#include "../common/buf.h"
#include "../common/gencode.h"
#include "../common/number.h"
#include "../common/common.h"
#include "symbol.h"
#include "main.h"
/*}}}  */
/*{{{  #defines*/
/* unused byte */
#define A_TP_FPU        0x01
#define A_TP_FPSUPPORT  0x02
#define A_TP_EXTRAINST  0x04
#define A_TP_DBGSUPPORT 0x08
#define A_TP_MBS        0x80
/* cpu id */
#define A_T800    0x14
/* flags */
#define A_EXEC	  0x10
#define A_SEP	  0x20
/* r_type values */
#define R_ABBS		0
#define R_RELLBYTE	2
#define R_PCRBYTE	3
#define R_RELWORD	4
#define R_PCRWORD	5
#define R_RELLONG	6
#define R_PCRLONG	7
#define R_REL3BYTE	8
#define R_KBRANCHE	9
/* r_symndx for internal segments */
#define S_ABS		((unsigned short)-1)
#define S_TEXT		((unsigned short)-2)
#define S_DATA		((unsigned short)-3)
#define S_BSS		((unsigned short)-4)
/*}}}  */

/*{{{  types*/
/*{{{  Long_exec*/
typedef struct
{
  unsigned char a_magic[2];     /* magic number */
  unsigned char a_flags;        /* flags */
  unsigned char a_cpu;          /* cpu id */
  unsigned char a_hdrlen;       /* length of header */
  unsigned char a_unused;       /* reserved for future use */
  unsigned short a_version;     /* version stamp, not used */
  long a_text;                  /* size of text segement in bytes */
  long a_data;                  /* size of data segment in bytes */
  long a_bss;                   /* size of bss segment in bytes */
  long a_entry;                 /* entry point */
  long a_total;                 /* total memory allocated */
  long a_syms;                  /* size of symbol table */
                                /* --- SHORT FORM ENDS HERE --- */
  long a_trsize;                /* text relocation size */
  long a_drsize;                /* data relocation size */
  long a_tbase;                 /* text relocation base */
  long a_dbase;                 /* data relocation base */
} Long_exec;
/*}}}  */
/*{{{  Short_exec*/
typedef struct
{
  unsigned char a_magic[2];     /* magic number */
  unsigned char a_flags;        /* flags */
  unsigned char a_cpu;          /* cpu id */
  unsigned char a_hdrlen;       /* length of header */
  unsigned char a_unused;       /* reserved for future use */
  unsigned short a_version;     /* version stamp, not used */
  long a_text;                  /* size of text segement in bytes */
  long a_data;                  /* size of data segment in bytes */
  long a_bss;                   /* size of bss segment in bytes */
  long a_entry;                 /* entry point */
  long a_total;                 /* total memory allocated */
  long a_syms;                  /* size of symbol table */
} Short_exec;
/*}}}  */
/*{{{  A_out_reloc*/
typedef struct
{
  long r_vaddr;               /* virtual address of reference */
  unsigned char r_symndx[2];  /* internal segnum or extern symbol num */
  unsigned char r_type[2];    /* relocation type */
} A_out_reloc;
/*}}}  */
/*{{{  Reloc*/
typedef struct Reloc
{
  long addr;
  struct Reloc *next;
} Reloc;
/*}}}  */
/*}}}  */
/*{{{  variable declarations*/
private FILE *infp, *outfp;
private int tag;
private unsigned long pc, value;
private int pass=1;
private char symbol[SYMBOL_LENGTH+1];
private char stcksym[SYMBOL_LENGTH+1];
private Bool working;
private unsigned long stack[STACK_DEPTH];
private int stackptr;
private unsigned char *lengths,*lengths_mem;
private int defined;
/*}}}  */

int myfread(char *p,int sz,int n,FILE *fp)
{
  assert(n==1);
  while (sz) { *p=fgetc(fp); --sz; ++p; }
  if (feof(fp)) return 0; else return 1;
}
#define fread myfread

/*{{{  read_symbol*/
private void read_symbol(FILE *fp, char *s)
{
  while ((*s++=getc(fp)));
}
/*}}}  */
/*{{{  primary*/
private void primary(unsigned char code)
{
  int extra;

  read_symbol(infp,symbol);
  get_symbol(symbol,&value,pass,&defined);
  assert(defined);
  pc+=(*lengths)+1;
  extra=(*lengths)-codelen(value);
  assert(extra>=0);
  while (extra>0) { buf_putc(0x20); --extra; }
  buf_putc(code|gencode(value));
  ++lengths;
}
/*}}}  */
/*{{{  fix*/
private void fix(unsigned char code)
{
  read_symbol(infp,symbol);
  pc++;
  get_symbol(symbol,&value,pass,&defined);
  assert(defined);
  if (code)
  {
    if (value>15) error("ld: nibble symbol %s out of range",symbol,"");
    buf_putc(code|(char)value);
  }
  else
  {
    if (value>255) error("ld: byte symbol %s out of range",symbol,"");
    buf_putc(value);
  }
}
/*}}}  */
/*{{{  relative*/
private void relative(unsigned char code)
{
  int extra;

  read_symbol(infp,symbol);
  get_symbol(symbol,&value,pass,&defined);
  assert(defined);
  pc+=(*lengths)+1;
  extra=(*lengths)-codelen(value-pc);
  assert(extra>=0);
  while (extra>0) { buf_putc(0x20); --extra; }
  buf_putc(code|gencode(value-pc));
  ++lengths;
}
/*}}}  */
/*{{{  nrelative*/
private void nrelative(unsigned char code)
{
  int extra;

  read_symbol(infp,symbol);
  get_symbol(symbol,&value,pass,&defined);
  assert(defined);
  pc+=(*lengths)+1;
  extra=(*lengths)-codelen(pc-value);
  assert(extra>=0);
  while (extra>0) { buf_putc(0x20); --extra; }
  buf_putc(code|gencode(pc-value));
  ++lengths;
}
/*}}}  */
/*{{{  init stack*/
private void init_stack(void)
{
  stackptr=-1;
}
/*}}}  */
/*{{{  push value*/
private void push_stack(unsigned long value)
{
  if (stackptr==STACK_DEPTH-1) fatal(1,"ld: symbol expression stack overflow","");
  else stack[++stackptr]=value;
}
/*}}}  */
/*{{{  pop value*/
private unsigned long pop_stack(void)
{
  return (stack[stackptr--]);
}
/*}}}  */

/*{{{  ld*/
public void ld(FILE *tmpfp, int a_unused)
{
  /*{{{  variables*/
  Long_exec long_exec;
  Short_exec short_exec;
  Reloc *reloc_root=(Reloc*)0,*reloc_append=(Reloc*)0;
  /*}}}  */

  /*{{{  open output file*/
  if ((out=buf_open(*outfile ? outfile : OUTFILE,O_WRONLY|O_CREAT|O_TRUNC,0666))<0)
  fatal(1,"ld: Can't open output file %s",*outfile ? outfile : OUTFILE);
  /*}}}  */
  infp=tmpfp;
  lengths_mem=xmalloc(nolengths);
  memset(lengths_mem,0,nolengths);
  do
  {
    working=FALSE;
    /*{{{  calculate new lengths*/
    if (verbose) fprintf(stderr,"ld: pass %d\n",pass);
    pc=startpc;
    rewind(infp);
    lengths=lengths_mem;
    while ((tag=getc(infp))!=EOF)
    {
      switch (tag)
      {
        /*{{{  ALIGN*/
        case ALIGN: while (pc & 3L) pc++; break;
        /*}}}  */
        /*{{{  RELOCATE*/
        case RELOCATE: break;
        /*}}}  */
        /*{{{  CODE*/
        case CODE:
        {
          int len;
          char buff[255];
        
          len=fgetc(infp);
          assert(len>0 && len<=255);
          pc+=len;
          len=fread(buff,len,1,infp);
          assert(len==1);
          break;
        }
        /*}}}  */
        /*{{{  EQU*/
        case EQU:
        {
          int def=1;
        
          read_symbol(infp,symbol);
          init_stack();
        
          while ((tag=getc(infp))!=EOF && tag!=ENDEQU)
          /*{{{  evaluate record*/
          {
            switch (tag)
            {
              /*{{{  SYMBOL*/
              case SYMBOL:
              {
                read_symbol(infp,stcksym);
                if (get_symbol(stcksym,&value,pass,&defined)) push_stack(value);
                else push_stack(0);
                if (!defined) def=0;
                break;
              }
              /*}}}  */
              /*{{{  NUMBER*/
              case NUMBER:
              {
                push_stack(getlong(infp));
                break;
              }
              /*}}}  */
              /*{{{  SUB*/
              case SUB:
              {
                value=pop_stack();
                push_stack(pop_stack()-value);
                break;
              }
              /*}}}  */
              /*{{{  ADD*/
              case ADD:
              {
                push_stack(pop_stack()+pop_stack());
                break;
              }
              /*}}}  */
              /*{{{  DIV*/
              case DIV:
              {
                if (def && (value=pop_stack())==0) fatal(1,"ld: division by zero in symbol expression","");
                push_stack(pop_stack()/(def ? value : 1));
                break;
              }
              /*}}}  */
              /*{{{  MULT*/
              case MULT:
              {
                push_stack(pop_stack()*pop_stack());
                break;
              }
              /*}}}  */
              /*{{{  NEGATE*/
              case NEGATE:
              {
                long v=pop_stack();
              
                assert(v!=LONG_MIN);
                push_stack(-v);
                break;
              }
              /*}}}  */
              /*{{{  default*/
              default:
              fprintf(stderr,"ld: weird symbol expression tag %d at offset 0x%lx\n",tag,ftell(infp));
              exit(255);
              /*}}}  */
            }
          }
          /*}}}  */
          value=pop_stack();
        
          if (pass==1) add_symbol(symbol,value,def);
          else if (update_symbol(symbol,value,def)) working=TRUE;
          break;
        }
        /*}}}  */
        /*{{{  DS*/
        case DS:
        {
          unsigned long value;
        
          value=getlong(infp);
          pc+=value;
          break;
        }
        /*}}}  */
        /*{{{  PFIX, NFIX, D8*/
        case PFIX:
        case NFIX:
        case D8: ++pc; read_symbol(infp,symbol); break;
        /*}}}  */
        /*{{{  D16*/
        case D16: pc+=2; read_symbol(infp,symbol); break;
        /*}}}  */
        /*{{{  D32*/
        case D32: pc+=4; read_symbol(infp,symbol); break;
        /*}}}  */
        /*{{{  LABEL*/
        case LABEL:
        {
          read_symbol(infp,symbol);
          if (pass==1) add_symbol(symbol,pc,1);
          else if (update_symbol(symbol,pc,1)) working=TRUE;
          break;
        }
        /*}}}  */
        /*{{{  LDPI*/
        case LDPI:
        {
          int len;
        
          pc+=(*lengths)+3;
          read_symbol(infp,symbol);
          get_symbol(symbol,&value,pass,&defined);
          if (defined) { if ((len=codelen(value-pc))>(*lengths)) { *lengths=len; working=TRUE; } }
          else working=TRUE;
          lengths++;
          break;
        }
        /*}}}  */
        /*{{{  LEND*/
        case LEND:
        {
          int len;
        
          pc+=(*lengths)+3;
          read_symbol(infp,symbol);
          get_symbol(symbol,&value,pass,&defined);
          if (defined) { if ((len=codelen(pc-value))>(*lengths)) { *lengths=len; working=TRUE; } }
          else working=TRUE;
          lengths++;
          break;
        }
        /*}}}  */
        /*{{{  CJ, CALL, JUMP*/
        case CJ:
        case CALL:
        case JUMP:
        {
          int len;
        
          pc+=(*lengths)+1;
          read_symbol(infp,symbol);
          get_symbol(symbol,&value,pass,&defined);
          if (defined) { if ((len=codelen(value-pc))>(*lengths)) { *lengths=len; working=TRUE; } }
          else working=TRUE;
          ++lengths;
          break;
        }
        /*}}}  */
        /*{{{  default*/
        default:
        {
          int len;
        
          assert(tag<LAST_TAG);
          pc+=(*lengths)+1;
          read_symbol(infp,symbol);
          get_symbol(symbol,&value,pass,&defined);
          if (defined) { if ((len=codelen(value))>(*lengths)) { *lengths=len; working=TRUE; } }
          else working=TRUE;
          lengths++;
          break;
        }
        /*}}}  */
      }
    }
    ++pass;
    /*}}}  */
    /*{{{  update symbol table*/
    if (verbose) fprintf(stderr,"ld: pass %d\n",pass);
    pc=startpc;
    rewind(infp);
    lengths=lengths_mem;
    while ((tag=getc(infp))!=EOF)
    {
      switch (tag)
      {
        /*{{{  ALIGN*/
        case ALIGN: while (pc & 3L) pc++; break;
        /*}}}  */
        /*{{{  RELOCATE*/
        case RELOCATE: break;
        /*}}}  */
        /*{{{  CODE*/
        case CODE:
        {
          int len;
          char buff[255];
        
          len=getc(infp);
          pc+=len;
          fread(buff,len,1,infp);
          break;
        }
        /*}}}  */
        /*{{{  EQU*/
        case EQU:
        {
          int def=1;
        
          read_symbol(infp,symbol);
          init_stack();
        
          while ((tag=getc(infp))!=EOF && tag!=ENDEQU)
          /*{{{  evaluate record*/
          {
            switch (tag)
            {
              /*{{{  SYMBOL*/
              case SYMBOL:
              {
                read_symbol(infp,stcksym);
                if (get_symbol(stcksym,&value,pass,&defined)) push_stack(value);
                else push_stack(0);
                if (!defined) def=0;
                break;
              }
              /*}}}  */
              /*{{{  NUMBER*/
              case NUMBER:
              {
                push_stack(getlong(infp));
                break;
              }
              /*}}}  */
              /*{{{  SUB*/
              case SUB:
              {
                value=pop_stack();
                push_stack(pop_stack()-value);
                break;
              }
              /*}}}  */
              /*{{{  ADD*/
              case ADD:
              {
                push_stack(pop_stack()+pop_stack());
                break;
              }
              /*}}}  */
              /*{{{  DIV*/
              case DIV:
              {
                if (defined && (value=pop_stack())==0) fatal(1,"ld: division by zero in symbol expression","");
                push_stack(pop_stack()/(defined ? value : 1));
                break;
              }
              /*}}}  */
              /*{{{  MULT*/
              case MULT:
              {
                push_stack(pop_stack()*pop_stack());
                break;
              }
              /*}}}  */
              /*{{{  NEGATE*/
              case NEGATE:
              {
                long v=pop_stack();
              
                assert(v!=LONG_MIN);
                push_stack(-v);
                break;
              }
              /*}}}  */
              /*{{{  default*/
              default:
              fprintf(stderr,"ld: weird symbol expression tag %d at offset 0x%lx\n",tag,ftell(infp));
              exit(255);
              /*}}}  */
            }
          }
          /*}}}  */
          value=pop_stack();
        
          if (update_symbol(symbol,value,def)) working=TRUE;
          break;
        }
        /*}}}  */
        /*{{{  DS*/
        case DS:
        {
          unsigned long value;
        
          value=getlong(infp);
          pc+=value;
          break;
        }
        /*}}}  */
        /*{{{  NFIX, PFIX, DB*/
        case NFIX:
        case PFIX:
        case D8: pc+=1; read_symbol(infp,symbol); break;
        /*}}}  */
        /*{{{  case D16*/
        case D16: pc+=2; read_symbol(infp,symbol); break;
        /*}}}  */
        /*{{{  DW*/
        case D32: pc+=4; read_symbol(infp,symbol); break;
        /*}}}  */
        /*{{{  LABEL*/
        case LABEL:
        {
          read_symbol(infp,symbol);
          if (update_symbol(symbol,pc,1)) working=TRUE;
          break;
        }
        /*}}}  */
        /*{{{  LDPI, LEND*/
        case LDPI:
        case LEND: pc+=(*lengths++)+3; read_symbol(infp,symbol); break;
        /*}}}  */
        /*{{{  default*/
        default: assert(tag<LAST_TAG); pc+=(*lengths++)+1; read_symbol(infp,symbol); break;
        /*}}}  */
      }
    }
    ++pass;
    /*}}}  */
  } while (working && !err);
  if (!err)
  {
    /*{{{  deal with headers, if any*/
    if (long_a_out)
    /*{{{  write long header*/
    {
      int n;
      char *p=(char*)&long_exec;
    
      long_exec.a_magic[0]=A_MAGIC0;
      long_exec.a_magic[1]=A_MAGIC1;
      long_exec.a_flags=A_EXEC;
      long_exec.a_cpu=0x14;
      long_exec.a_hdrlen=sizeof(Long_exec);
      long_exec.a_unused=a_unused;
      long_exec.a_version=0;
      long_exec.a_text=pc-startpc;
      long_exec.a_data=0;
      long_exec.a_bss=0;
      long_exec.a_entry=0;
      long_exec.a_total=long_exec.a_text+long_exec.a_data+long_exec.a_bss+chmem;
      if (nosym) long_exec.a_syms=0;
      else long_exec.a_syms=size_table()*sizeof(struct nlist);
      long_exec.a_trsize=num_reloc*sizeof(A_out_reloc);
      long_exec.a_drsize=0;
      long_exec.a_tbase=startpc;
      long_exec.a_dbase=0;
      for (n=0; n<sizeof(Long_exec); ++n) { buf_putc(*p); ++p; }
    }
    /*}}}  */
    else if (short_a_out && num_reloc==0)
    /*{{{  perhaps write header*/
    {
      int n;
      char *p=(char*)&short_exec;
    
      short_exec.a_magic[0]=A_MAGIC0;
      short_exec.a_magic[1]=A_MAGIC1;
      short_exec.a_flags=A_EXEC;
      short_exec.a_cpu=0x14;
      short_exec.a_hdrlen=sizeof(Short_exec);
      short_exec.a_unused=a_unused;
      short_exec.a_version=0;
      short_exec.a_text=pc-startpc;
      short_exec.a_data=0;
      short_exec.a_bss=0;
      short_exec.a_entry=0;
      short_exec.a_total=short_exec.a_text+short_exec.a_data+short_exec.a_bss+chmem;
      if (nosym) short_exec.a_syms=0;
      else short_exec.a_syms=size_table()*sizeof(struct nlist);
    
      for (n=0; n<sizeof(short_exec); ++n) { buf_putc(*p); ++p; }
    }
    /*}}}  */
    else if (short_a_out && num_reloc)
    /*{{{  fatal*/
    {
      fatal(1,"ld: short header is not possible when relocation is used","");
    }
    /*}}}  */
    /*}}}  */
    /*{{{  output code*/
    pc=startpc;
    rewind(infp);
    lengths=lengths_mem;
    while ((tag=getc(infp))!=EOF)
    {
      switch (tag)
      {
        /*{{{  ALIGN*/
        case ALIGN: while (pc & 3L) { pc++; buf_putc(0); } break;
        /*}}}  */
        /*{{{  RELOCATE*/
        case RELOCATE:
        {
          if (long_a_out)
          {
            if (reloc_append)
            {
              reloc_append->next=xmalloc(sizeof(Reloc));
              reloc_append=reloc_append->next;
            }
            else reloc_root=reloc_append=xmalloc(sizeof(Reloc));
            reloc_append->next=(Reloc*)0;
            reloc_append->addr=pc-startpc;
          }
          break;
        }
        /*}}}  */
        /*{{{  CODE*/
        case CODE:
        {
          int len,n;
          char buff[255];
        
          len=getc(infp);
          pc+=len;
          fread(buff,len,1,infp);
          for (n=0; n<len; ++n) buf_putc(buff[n]);
          break;
        }
        /*}}}  */
        /*{{{  EQU*/
        case EQU:
        {
          read_symbol(infp,symbol);
          init_stack();
        
          while ((tag=getc(infp))!=EOF && tag!=ENDEQU)
          /*{{{  evaluate record*/
          {
            switch (tag)
            {
              /*{{{  SYMBOL*/
              case SYMBOL:
              {
                read_symbol(infp,stcksym);
                get_symbol(stcksym,&value,pass,&defined);
                assert(defined);
                push_stack(value);
                break;
              }
              /*}}}  */
              /*{{{  NUMBER*/
              case NUMBER:
              {
                push_stack(getlong(infp));
                break;
              }
              /*}}}  */
              /*{{{  SUB*/
              case SUB:
              {
                value=pop_stack();
                push_stack(pop_stack()-value);
                break;
              }
              /*}}}  */
              /*{{{  ADD*/
              case ADD:
              {
                push_stack(pop_stack()+pop_stack());
                break;
              }
              /*}}}  */
              /*{{{  DIV*/
              case DIV:
              {
                if ((value=pop_stack())==0) fatal(1,"ld: division by zero in symbol expression","");
                push_stack(pop_stack()/value);
                break;
              }
              /*}}}  */
              /*{{{  MULT*/
              case MULT:
              {
                push_stack(pop_stack()*pop_stack());
                break;
              }
              /*}}}  */
              /*{{{  NEGATE*/
              case NEGATE:
              {
                long v=pop_stack();
              
                assert(v!=LONG_MIN);
                push_stack(-v);
                break;
              }
              /*}}}  */
              /*{{{  default*/
              default:
              fprintf(stderr,"ld: weird symbol expression tag %d at offset 0x%lx\n",tag,ftell(infp));
              exit(255);
              /*}}}  */
            }
          }
          /*}}}  */
          value=pop_stack();
        
          assert(!update_symbol(symbol,value,1));
          break;
        }
        /*}}}  */
        /*{{{  DS*/
        case DS:
        {
          unsigned long value;
        
          value=getlong(infp);
          pc+=value;
          while (value--) buf_putc(0);
          break;
        }
        /*}}}  */
        /*{{{  NFIX*/
        case NFIX: fix(0x60); break;
        /*}}}  */
        /*{{{  PFIX*/
        case PFIX: fix(0x20); break;
        /*}}}  */
        /*{{{  D8*/
        case D8: fix(0x00); break;
        /*}}}  */
        /*{{{  D16*/
        case D16:
        {
          read_symbol(infp,symbol);
          get_symbol(symbol,&value,pass,&defined);
          assert(defined);
          pc+=2;
          buf_putc((char)(value&0xff));
          buf_putc((char)((value>>8)&0xff));
          break;
        }
        /*}}}  */
        /*{{{  D32*/
        case D32:
        {
          read_symbol(infp,symbol);
          get_symbol(symbol,&value,pass,&defined);
          assert(defined);
          pc+=4;
          buf_putc((char)(value&0xff));
          buf_putc((char)((value>>8)&0xff));
          buf_putc((char)((value>>16)&0xff));
          buf_putc((char)((value>>24)&0xff));
          break;
        }
        /*}}}  */
        /*{{{  LABEL*/
        case LABEL:
        {
          read_symbol(infp,symbol);
          assert(!update_symbol(symbol,pc,1));
          break;
        }
        /*}}}  */
        /*{{{  LDPI*/
        case LDPI: pc+=2; relative(0x40); buf_putc(0x21); buf_putc(0xfb); break;
        /*}}}  */
        /*{{{  LEND*/
        case LEND: pc+=2; nrelative(0x40); buf_putc(0x22); buf_putc(0xf1); break;
        /*}}}  */
        /*{{{  AJW*/
        case AJW: primary(0xb0); break;
        /*}}}  */
        /*{{{  ADC*/
        case ADC: primary(0x80); break;
        /*}}}  */
        /*{{{  LDC*/
        case LDC: primary(0x40); break;
        /*}}}  */
        /*{{{  LDLP*/
        case LDLP: primary(0x10); break;
        /*}}}  */
        /*{{{  LDNL*/
        case LDNL: primary(0x30); break;
        /*}}}  */
        /*{{{  LDNLP*/
        case LDNLP: primary(0x50); break;
        /*}}}  */
        /*{{{  LDL*/
        case LDL: primary(0x70); break;
        /*}}}  */
        /*{{{  EQC*/
        case EQC: primary(0xc0); break;
        /*}}}  */
        /*{{{  STL*/
        case STL: primary(0xd0); break;
        /*}}}  */
        /*{{{  STNL*/
        case STNL: primary(0xe0); break;
        /*}}}  */
        /*{{{  CJ*/
        case CJ: relative(0xa0); break;
        /*}}}  */
        /*{{{  CALL*/
        case CALL: relative(0x90); break;
        /*}}}  */
        /*{{{  JUMP*/
        case JUMP: relative(0x00); break;
        /*}}}  */
        /*{{{  default*/
        default:
        fprintf(stderr,"ld: weird tag %d at offset 0x%lx\n",tag,ftell(infp));
        exit(255);
        break;
        /*}}}  */
      }
    }
    /*}}}  */
    /*{{{  write relocation table if any*/
    if (long_a_out)
    {
      while (reloc_root!=(Reloc*)0)
      {
        A_out_reloc entry;
        int n;
        char *p;
    
        entry.r_vaddr=reloc_root->addr;
        /* grrrr */
        entry.r_symndx[0]=S_TEXT & 0xff;
        entry.r_symndx[1]=S_TEXT >> 8;
        entry.r_type[0]=R_RELWORD & 0xff;
        entry.r_type[1]=R_RELWORD >> 8;
        p=(char*)&entry;
        for (n=0; n<sizeof(entry); ++n) { buf_putc(*p); ++p; }
        reloc_root=reloc_root->next;
      }
    }
    /*}}}  */
    /*{{{  write symbol table*/
    if ((short_a_out || long_a_out) && !nosym)
    {
      hdr_table();
    }
    /*}}}  */
    /*{{{  close output file*/
    buf_close();
    /*}}}  */
    /*{{{  write symbol table*/
    if (*symfile) if ((outfp=fopen(symfile,"w"))==(FILE*)0) fatal(1,"ld: Can't open symbol table %s",symfile);
    else
    {
      dump_table(outfp);
      fclose(outfp);
    }
    /*}}}  */
  }
  /*{{{  exit*/
  if (err)
  {
    unlink(*outfile ? outfile : OUTFILE);
    exit(1);
  }
  /*}}}  */
}
/*}}}  */
