/*{{{}}}*/
/*{{{  Notes*/
/*

K&R, Appendix A.7:

The handling of overflow, divide check, and other exceptions in
expression evaluation is not defined by the language.  Most existing
implementations of C ignore overflow in evaluation of signed integral
expressions and assignments, but this behaviour is not guaranteed.

*/
/*}}}  */
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <ctype.h>
#include <stdio.h>

#include "../common/common.h"
/*}}}  */

/*{{{  posnumber*/
private unsigned long int posnumber(char *s, char **endptr)
{
  int base=10;
  unsigned char c;
  register char *nptr = s;
  unsigned long int result = 0L;
  Bool saw_a_digit = FALSE;

  if (*nptr == '0')
  {
    if ((c = *++nptr) == 'x' || c == 'X')
    {
      ++nptr;
      base = 16;
    }
    else
    {
      saw_a_digit = TRUE;        /* in case '0' is only digit */
      base = 8;
    }
  }

  --nptr;
  while ((c=*++nptr))
  {
    if (isdigit(c)) c -= '0';
    else if (isupper(c)) c -= ('A'-10);
    else if (islower(c)) c -= ('a'-10);
    else break;
    if (c>=base) break;
    saw_a_digit = TRUE;
    result = result*base+c;
  }

  *endptr=(saw_a_digit ? nptr : s);
  return result;
}
/*}}}  */
/*{{{  negnumber*/
private unsigned long int negnumber(char *s, char **endptr)
{
  /*{{{  variables*/
  int base=10;
  unsigned char c;
  register char *nptr=s+1;
  long int result=0;
  Bool saw_a_digit=FALSE;
  /*}}}  */

  if (*nptr=='0')
  {
    if ((c = *++nptr) == 'x' || c == 'X')
    {
      ++nptr;
      base = 16;
    }
    else
    {
      saw_a_digit = TRUE;        /* in case '0' is only digit */
      base = 8;
    }
  }

  --nptr;
  while ((c=*++nptr))
  {
    if (isdigit(c)) c -= '0';
    else if (isupper(c)) c -= ('A'-10);
    else if (islower(c)) c -= ('a'-10);
    else break;
    if (c>=base) break;
    saw_a_digit = TRUE;
    result = result*base-c;
  }

  *endptr=(saw_a_digit ? nptr : s);
  return result;
}
/*}}}  */
/*{{{  number*/
public unsigned long int number(char *s, char **endptr)
{
  if (*s=='-') return(negnumber(s,endptr));
  else return(posnumber(s,endptr));
}
/*}}}  */
