/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <ctype.h>
#include <stdio.h>

#include "common.h"
#include "buf.h"
/*}}}  */

/*{{{  codelen*/
public int codelen(unsigned long lval)
{
  int len;

  if (lval == 0) return 0;
  if (lval & 0x80000000U)
  /*{{{  negative numbers*/
  {
    len = 1;
    if ((0xFFFFFFFFU - lval) >= 0x100U) ++len;
    if ((0xFFFFFFFFU - lval) >= 0x1000U) ++len;
    if ((0xFFFFFFFFU - lval) >= 0x10000U) ++len;
    if ((0xFFFFFFFFU - lval) >= 0x100000U) ++len;
    if ((0xFFFFFFFFU - lval) >= 0x1000000U) ++len;
    if ((0xFFFFFFFFU - lval) >= 0x10000000U) ++len;
  }
  /*}}}  */
  else
  /*{{{  positive numbers*/
  {
    len = 0;
    if (lval >= (unsigned long) 0x10L) ++len;
    if (lval >= (unsigned long) 0x100L) ++len;
    if (lval >= (unsigned long) 0x1000L) ++len;
    if (lval >= (unsigned long) 0x10000L) ++len;
    if (lval >= (unsigned long) 0x100000L) ++len;
    if (lval >= (unsigned long) 0x1000000L) ++len;
    if (lval >= (unsigned long) 0x10000000L) ++len;
  }
  /*}}}  */
  return (len);
}
/*}}}  */
/*{{{  gencode*/
public unsigned char gencode(unsigned long lval)
{
  int  i;
  char cval;
  Bool sent, nval;

  if (lval > 0xFL)
  {
    sent = FALSE;
    nval = (lval > 0x7FFFFFFFL);

    for (i = 1; i < 8; i++)
    {
      cval = (char) ((lval & 0xF0000000L) >> 28);
      if (((cval != 0) && !nval) || sent || ((cval != 0xF) && nval))
      {
        if (nval && !sent) cval = (0x60 | (char) (~cval & 0xF));
        else cval = (0x20 | cval);
        buf_putc(cval);
        sent = TRUE;
      }
      lval <<= 4;
    }
    if (nval && !sent) buf_putc(0x60);
    return ((unsigned char) ((lval & 0xF0000000L) >> 28));
  }
  return ((unsigned char) lval);
}
/*}}}  */
