#ifndef COMMON_COMMON_H
#define COMMON_COMMON_H

/*{{{}}}*/
/*{{{  #defines*/
#define private static
#define public

#define OUTFILE "a.out"
#define OBJECT ".o"

#define SYMBOL_LENGTH 32
#define MODULE_NUMBER 4096
#define STACK_DEPTH 32
/*}}}  */

/*{{{  Bool*/
typedef enum { FALSE, TRUE } Bool;
/*}}}  */
/*{{{  Chip*/
typedef enum
{
  T212=1, T222=2, T225=4, T400=8, T414=16, T425=32, T426=64, T800=128, T801=256, T805=512
} Chip;
/*}}}  */
/*{{{  Tag*/
#define LABEL     0
#define CODE      1
#define EQU       2
#define ENDEQU    3
#define SYMBOL    4
#define NUMBER    5
#define SUB       6
#define ADD       7
#define MULT      8
#define DIV       9
#define NEGATE   10
#define AJW      11
#define ADC      12
#define ALIGN    13
#define LDC      14
#define LDLP     15
#define LDNL     16
#define LDNLP    17
#define LDL      18
#define CJ       19
#define CALL     20
#define D8       21
#define D16      22
#define D32      23
#define DS       24
#define EQC      25
#define STL      26
#define STNL     27
#define JUMP     28
#define PFIX     29
#define NFIX     30
#define LDPI     31
#define LEND     32
#define RELOCATE 33
#define LAST_TAG 34
/*}}}  */

#endif
