#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

/*{{{}}}*/
/*{{{  variables*/
static char buf[1024];
static char *bufptr;
static int count;
int out;
/*}}}  */

/*{{{  buf_open*/
int buf_open(char *name, int flags, mode_t mode)
{
  count=0;
  bufptr=buf;
  return (out=open(name,flags,mode));
}
/*}}}  */
/*{{{  buf_putc*/
void buf_putc(char c)
{
  *bufptr=c;
  ++bufptr;
  ++count;
  if (count==1024)
  {
    write(out,buf,1024);
    bufptr=buf;
    count=0;
  }  
}
/*}}}  */
/*{{{  buf_close*/
int buf_close(void)
{
  if (count) write(out,buf,count);
  return close(out);
}
/*}}}  */
/*{{{  buf_puts*/
void buf_puts(char *s)
{
  while (*s) { buf_putc(*s); ++s; }
}
/*}}}  */
