/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <ctype.h>
#include <stdio.h>

#include "../common/getputlong.h"
#include "../common/buf.h"
#include "../common/gencode.h"
#include "../common/number.h"
#include "error.h"

#define OUTPUT_C
#include "main.h"
/*}}}  */

/*{{{  primary*/
public void primary(int tag, unsigned char code)
{
  /*{{{  variable declarations*/
  unsigned long value;
  char *ptr=operand;
  /*}}}  */

  if (*operand=='\0') { lnerror("Operand needed"); return; }
  value=number(operand,&ptr);
  if (ptr!=operand)
  {
    buf_putc(CODE);
    buf_putc(codelen(value)+1);
    buf_putc(code|gencode(value));
  }
  else
  {
    buf_putc(tag);
    buf_puts(operand);
    buf_putc('\0');
  }
}
/*}}}  */
/*{{{  fix*/
private void fix(int tag, unsigned char code)
{
  /*{{{  variable declarations*/
  unsigned long value;
  char *ptr=operand;
  /*}}}  */

  value=number(operand,&ptr);
  if (ptr!=operand)
  {
    if (value<((unsigned long)-8) || value>15) lnerror("nibble value out of range");
    buf_putc(CODE);
    buf_putc(1);
    buf_putc(code|(char)value);
  }
  else
  {
    buf_putc(tag);
    buf_puts(operand);
    buf_putc('\0');
  }
}
/*}}}  */

/*{{{  put_tag*/
public void put_tag(int tag)
{
  /*{{{  variable declarations*/
  unsigned long value;
  char *ptr=operand, *lastptr;
  /*}}}  */

  switch (tag)
  {
    /*{{{  ALIGN*/
    case ALIGN: buf_putc(ALIGN); break;
    /*}}}  */
    /*{{{  AJW*/
    case AJW: primary(tag,0xb0); break;
    /*}}}  */
    /*{{{  ADC*/
    case ADC: primary(tag,0x80); break;
    /*}}}  */
    /*{{{  LDC*/
    case LDC: primary(tag,0x40); break;
    /*}}}  */
    /*{{{  LDLP*/
    case LDLP: primary(tag,0x10); break;
    /*}}}  */
    /*{{{  LDNL*/
    case LDNL: primary(tag,0x30); break;
    /*}}}  */
    /*{{{  LDNLP*/
    case LDNLP: primary(tag,0x50); break;
    /*}}}  */
    /*{{{  LDL*/
    case LDL: primary(tag,0x70); break;
    /*}}}  */
    /*{{{  EQC*/
    case EQC: primary(tag,0xc0); break;
    /*}}}  */
    /*{{{  STL*/
    case STL: primary(tag,0xd0); break;
    /*}}}  */
    /*{{{  STNL*/
    case STNL: primary(tag,0xe0); break;
    /*}}}  */
    /*{{{  PFIX*/
    case PFIX: fix(tag,0x20); break;
    /*}}}  */
    /*{{{  NFIX*/
    case NFIX: fix(tag,0x60); break;
    /*}}}  */
    /*{{{  D8*/
    case D8:
    {
      do
      /*{{{  process operand*/
      {
        if (*ptr=='"')
        /*{{{  string constant*/
        {
          while (*++ptr && *ptr!='"')
          /*{{{  process character*/
          {
            if (*ptr=='\\')
            /*{{{  process multicharacter constants*/
            {
              switch (*++ptr)
              {
                /*{{{  0*/
                case '0':
                {
                  value=0;
                  while (*ptr>='0' && *ptr<='7') value=value*8+*ptr++-'0';
                  ptr--;
                  if (value>255) lnerror("character value out of range");
                  buf_putc(CODE);
                  buf_putc(1);
                  buf_putc((char)value);
                  break;
                }
                /*}}}  */
                /*{{{  n*/
                case 'n':
                {
                  buf_putc(CODE);
                  buf_putc(1);
                  buf_putc('\n');
                  break;
                }
                /*}}}  */
                /*{{{  r*/
                case 'r':
                {
                  buf_putc(CODE);
                  buf_putc(1);
                  buf_putc('\r');
                  break;
                }
                /*}}}  */
                /*{{{  default*/
                default:
                {
                  buf_putc(CODE);
                  buf_putc(1);
                  buf_putc(*ptr);
                  break;
                }
                /*}}}  */
              }
            }
            /*}}}  */
            else
            /*{{{  process single character*/
            {
              buf_putc(CODE);
              buf_putc(1);
              buf_putc(*ptr);
            }
            /*}}}  */
          }
          /*}}}  */
          if (*ptr) ptr++;
        }
        /*}}}  */
        else
        /*{{{  number or symbol*/
        {
          lastptr=ptr;
          value=number(ptr,&ptr);
          if (ptr!=lastptr)
          /*{{{  number*/
          {
            buf_putc(CODE);
            buf_putc(1);
            if (((long)value)<-128 || ((long)value)>255) lnerror("8 bit value out of range");
            buf_putc((char)value);
          }
          /*}}}  */
          else
          /*{{{  symbol*/
          {
            buf_putc(D8);
            while (*ptr && *ptr!=' ' && *ptr!=',') buf_putc(*ptr++);
            buf_putc('\0');
          }
          /*}}}  */
        }
        /*}}}  */
        while (*ptr && (*ptr==' ' || *ptr==',')) ptr++;
      }
      /*}}}  */
      while (*ptr);
      break;
    }
    /*}}}  */
    /*{{{  D16*/
    case D16:
    {
      do
      /*{{{  process operand*/
      {
        lastptr=ptr;
        value=number(ptr,&ptr);
        if (ptr!=lastptr)
        /*{{{  number*/
        {
          if (((long)value)<-32768 || ((long)value)>0xffff) lnerror("16 bit value out of range");
          buf_putc(CODE);
          buf_putc(2);
          buf_putc((char)(value&0xff));
          buf_putc((char)((value>>8)&0xff));
        }
        /*}}}  */
        else
        /*{{{  symbol*/
        {
          buf_putc(D16);
          while (*ptr && *ptr!=' ' && *ptr!=',') buf_putc(*ptr++);
          buf_putc('\0');
        }
        /*}}}  */
        while (*ptr && (*ptr==' ' || *ptr==',')) ptr++;
      }
      /*}}}  */
      while (*ptr);
      break;
    }
    /*}}}  */
    /*{{{  D32*/
    case D32:
    {
      do
      /*{{{  process operand*/
      {
        lastptr=ptr;
        value=number(ptr,&ptr);
        if (ptr!=lastptr)
        /*{{{  number*/
        {
          buf_putc(CODE);
          buf_putc(4);
          buf_putc((char)(value&0xff));
          buf_putc((char)((value>>8)&0xff));
          buf_putc((char)((value>>16)&0xff));
          buf_putc((char)((value>>24)&0xff));
        }
        /*}}}  */
        else
        /*{{{  symbol*/
        {
          buf_putc(D32);
          while (*ptr && *ptr!=' ' && *ptr!=',') buf_putc(*ptr++);
          buf_putc('\0');
        }
        /*}}}  */
        while (*ptr && (*ptr==' ' || *ptr==',')) ptr++;
      }
      /*}}}  */
      while (*ptr);
      break;
    }
    /*}}}  */
    /*{{{  DS    */
    case DS:
    {
      lastptr=ptr;
      value=number(ptr,&ptr);
      if (ptr!=lastptr)
      {
        buf_putc(DS);
        buf_putc((char)(value&0xff));
        buf_putc((char)((value>>8)&0xff));
        buf_putc((char)((value>>16)&0xff));
        buf_putc((char)((value>>24)&0xff));
      }
      else lnerror("no size");
      break;
    }
    /*}}}  */
    /*{{{  RELOCATE*/
    case RELOCATE: buf_putc(RELOCATE); break;
    /*}}}  */
    /*{{{  default*/
    default:
    {
      buf_putc(tag);
      buf_puts(operand);
      buf_putc('\0');
      break;
    }
    /*}}}  */
  }
}
/*}}}  */
/*{{{  put_1_code*/
public void put_1_code(unsigned char x)
{
  buf_putc(CODE);
  buf_putc('\1');
  buf_putc(x);
}
/*}}}  */
/*{{{  put_2_code*/
public void put_2_code(unsigned char x, unsigned char y)
{
  buf_putc(CODE);
  buf_putc('\2');
  buf_putc(x);
  buf_putc(y);
}
/*}}}  */
/*{{{  put_3_code*/
public void put_3_code(unsigned char x, unsigned char y, unsigned char z)
{
  buf_putc(CODE);
  buf_putc('\3');
  buf_putc(x);
  buf_putc(y);
  buf_putc(z);
}
/*}}}  */
/*{{{  put_label*/
public void put_label(char *l)
{
  buf_putc(LABEL);
  buf_puts(l);
  buf_putc('\0');
}
/*}}}  */

/*{{{  term parser*/
/*{{{  EBNF*/
/*

term    ::= sum

symbol  ::= (letter | underscore | at) { letter | underscore | at | digit }
constant::= ('0' ('x'|'X')) | digit { digit }
sum     ::= product { ('+' | '-') product }
product ::= factor { ('*' | '/') factor }
factor  ::= ( ['-'] constant ) | ( ['-'] value )
value   ::= symbol | ('(' sum ')')

The strange factor rule is neccessary to parse MININT without overflow.

*/
/*}}}  */

private char *scan;
private Bool sum(void);

/*{{{  symbol*/
private Bool symbol(void)
{
  if (*scan=='_' || *scan=='@' || isalpha(*scan))
  /*{{{  we have a symbol*/
  {
    buf_putc(SYMBOL);
    /*{{{  accept an unlimited number of letters, digits or underscores*/
    while (*scan=='_' || *scan=='@' || isalnum(*scan)) buf_putc(*scan++);
    /*}}}  */
    buf_putc('\0');
    return TRUE;
  }
  /*}}}  */
  else return FALSE;
}
/*}}}  */

/*{{{  value*/
private Bool value(void)
{
  if (*scan=='(')
  {
    scan++;
    if (sum())
    {
      if (*scan==')')
      {
        scan++;
        return TRUE;
      }
      else
      {
        printf(") expected\n");
        return FALSE;
      }
    }
    else return FALSE;
  }
  else if (symbol()) return TRUE;
  else
  {
    printf("opening paren or symbol expected\n");
    return FALSE;
  }
}
/*}}}  */
/*{{{  factor*/
private Bool factor(void)
{
  char op,*s;
  unsigned long int val;

  op=(*scan=='-');
  val=number(scan,&s);
  if (s!=scan)
  {
    scan=s;
    buf_putc(NUMBER);
    buf_putc((char)(val&0xff));
    buf_putc((char)((val>>8)&0xff));
    buf_putc((char)((val>>16)&0xff));
    buf_putc((char)((val>>24)&0xff));
    return TRUE;
  }
  else
  {
    if (op) ++scan;
    if (value())
    {
      if (op) buf_putc(NEGATE);
      return TRUE;
    }
  }
  return FALSE;
}
/*}}}  */
/*{{{  product*/
private Bool product(void)
{
  char op;

  if (factor())
  {
    while (*scan=='*' || *scan=='/')
    {
      op= *scan++;
      if (factor()) buf_putc(op=='*' ? MULT : DIV);
      else return FALSE;
    }
    return TRUE;
  }
  else return FALSE;
}
/*}}}  */
/*{{{  sum*/
private Bool sum(void)
{
  char op;

  if (product())
  {
    while (*scan=='+' || *scan=='-')
    {
      op= *scan++;
      if (product()) buf_putc(op=='+' ? ADD : SUB);
      else return FALSE;
    }
    return TRUE;
  }
  else return FALSE;
}
/*}}}  */
/*}}}  */
/*{{{  put_equ*/
public void put_equ(void)
{
  scan=operand;
  buf_putc(EQU);
  while (*scan && *scan!=' ' && *scan!=',') buf_putc(*scan++);
  buf_putc('\0');
  while (*scan && (*scan==' ' || *scan==',')) scan++;
  if (*scan=='\0') lnerror("missing term");
  else if (sum() && *scan!='\0') lnerror("trailing garbage");
  buf_putc(ENDEQU);
}
/*}}}  */
