/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_T_C
#include "main.h"
/*}}}  */

/*{{{  mne_t*/
Bool mne_t(void)
{
  /*{{{  t400*/
  if (!strcmp (mnemonic, "400"))
  {
    chip=T400;
    return TRUE;
  }
  /*}}}  */
  /*{{{  t414*/
  if (!strcmp (mnemonic, "414"))
  {
    chip=T414;
    return TRUE;
  }
  /*}}}  */
  /*{{{  t425*/
  if (!strcmp (mnemonic, "425"))
  {
    chip=T425;
    return TRUE;
  }
  /*}}}  */
  /*{{{  t800*/
  if (!strcmp (mnemonic, "800"))
  {
    chip=T800;
    return TRUE;
  }
  /*}}}  */
  /*{{{  t801*/
  if (!strcmp (mnemonic, "801"))
  {
    chip=T801;
    return TRUE;
  }
  /*}}}  */
  /*{{{  t805*/
  if (!strcmp (mnemonic, "805"))
  {
    chip=T805;
    return TRUE;
  }
  /*}}}  */
  /*{{{  tin*/
  if (!strcmp (mnemonic, "in"))
  {
    put_2_code(0x22,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  talt*/
  if (!strcmp (mnemonic, "alt"))
  {
    put_2_code(0x24,0xfe);
    return TRUE;
  }
  /*}}}  */
  /*{{{  taltwt*/
  if (!strcmp (mnemonic, "altwt"))
  {
    put_2_code(0x25,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  testerr*/
  if (!strcmp (mnemonic, "esterr"))
  {
    put_2_code(0x22,0xf9);
    return TRUE;
  }
  /*}}}  */
  /*{{{  testj0break*/
  if (!strcmp (mnemonic, "estj0break"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* testj0break */
    put_2_code(0x2b,0xf4);
    return TRUE;
  }
  /*}}}  */
  /*{{{  testhalterr*/
  if (!strcmp (mnemonic, "esthalterr"))
  {
    put_2_code(0x25,0xf9);
    return TRUE;
  }
  /*}}}  */
  /*{{{  testpranal*/
  if (!strcmp (mnemonic, "estpranal"))
  {
    put_2_code(0x22,0xfa);
    return TRUE;
  }
  /*}}}  */
  /*{{{  timerdisableh*/
  if (!strcmp (mnemonic, "imerdisableh"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* timerdisableh */
    put_2_code(0x27,0xfa);
    return TRUE;
  }
  /*}}}  */
  /*{{{  timerdisablel*/
  if (!strcmp (mnemonic, "imerdisablel"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* timerdisablel */
    put_2_code(0x27,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  timerenableh*/
  if (!strcmp (mnemonic, "imerenableh"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* timerenableh */
    put_2_code(0x27,0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  timerenablel*/
  if (!strcmp (mnemonic, "imerenablel"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* timerenablel */
    put_2_code(0x27,0xfd);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
