/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_S_C
#include "main.h"
/*}}}  */

/*{{{  mne_s*/
Bool mne_s(void)
{
  /*{{{  stl*/
  if (!strcmp (mnemonic, "tl"))
  {
    put_tag(STL);
    return TRUE;
  }
  /*}}}  */
  /*{{{  stnl*/
  if (!strcmp (mnemonic, "tnl"))
  {
    put_tag(STNL);
    return TRUE;
  }
  /*}}}  */
  /*{{{  shl*/
  if (!strcmp (mnemonic, "hl"))
  {
    put_2_code(0x24,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  shr*/
  if (!strcmp (mnemonic, "hr"))
  {
    put_2_code(0x24,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  sub*/
  if (!strcmp (mnemonic, "ub"))
  {
    put_1_code(0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  sum*/
  if (!strcmp (mnemonic, "um"))
  {
    put_2_code(0x25,0xf2);
    return TRUE;
  }
  /*}}}  */
  /*{{{  sb*/
  if (!strcmp (mnemonic, "b"))
  {
    put_2_code(0x23,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  startp*/
  if (!strcmp (mnemonic, "tartp"))
  {
    put_1_code(0xfd);
    return TRUE;
  }
  /*}}}  */
  /*{{{  stopp*/
  if (!strcmp (mnemonic, "topp"))
  {
    put_2_code(0x21,0xf5);
    return TRUE;
  }
  /*}}}  */
  /*{{{  seterr*/
  if (!strcmp (mnemonic, "eterr"))
  {
    put_2_code(0x21,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  stoperr*/
  if (!strcmp (mnemonic, "toperr"))
  {
    put_2_code(0x25,0xf5);
    return TRUE;
  }
  /*}}}  */
  /*{{{  sethalterr*/
  if (!strcmp (mnemonic, "ethalterr"))
  {
    put_2_code(0x25,0xf8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  saveh*/
  if (!strcmp (mnemonic, "aveh"))
  {
    put_2_code(0x23,0xfe);
    return TRUE;
  }
  /*}}}  */
  /*{{{  savel*/
  if (!strcmp (mnemonic, "avel"))
  {
    put_2_code(0x23,0xfd);
    return TRUE;
  }
  /*}}}  */
  /*{{{  sthf*/
  if (!strcmp (mnemonic, "thf"))
  {
    put_2_code(0x21,0xf8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  sthb*/
  if (!strcmp (mnemonic, "thb"))
  {
    put_2_code(0x25,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  stlf*/
  if (!strcmp (mnemonic, "tlf"))
  {
    put_2_code(0x21,0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  stlb*/
  if (!strcmp (mnemonic, "tlb"))
  {
    put_2_code(0x21,0xf7);
    return TRUE;
  }
  /*}}}  */
  /*{{{  sttimer*/
  if (!strcmp (mnemonic, "ttimer"))
  {
    put_2_code(0x25,0xf4);
    return TRUE;
  }
  /*}}}  */
  /*{{{  setj0break*/
  if (!strcmp (mnemonic, "etj0break"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* setj0break */
    put_2_code(0x2b,0xf3);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
