/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_R_C
#include "main.h"
/*}}}  */

/*{{{  mne_r*/
Bool mne_r(void)
{
  /*{{{  rem*/
  if (!strcmp (mnemonic, "em"))
  {
    put_2_code(0x21,0xff);
    return TRUE;
  }
  /*}}}  */
  /*{{{  reloc*/
  if (!strcmp (mnemonic, "eloc"))
  {
    put_tag(RELOCATE);
    return TRUE;
  }
  /*}}}  */
  /*{{{  rev*/
  if (!strcmp (mnemonic, "ev"))
  {
    put_1_code(0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  roundsn*/
  if (!strcmp (mnemonic, "oundsn"))
  {
    warn_chip(T400|T414|T425|T426); /* roundsn */
    put_2_code(0x26,0xfd);
    return TRUE;
  }
  /*}}}  */
  /*{{{  resetch*/
  if (!strcmp (mnemonic, "esetch"))
  {
    put_2_code(0x21,0xf2);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ret*/
  if (!strcmp (mnemonic, "et"))
  {
    put_2_code(0x22,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  runp*/
  if (!strcmp (mnemonic, "unp"))
  {
    put_2_code(0x23,0xf9);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
