/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_L_C
#include "main.h"
/*}}}  */

/*{{{  mne_l*/
Bool mne_l(void)
{
  /*{{{  ldlp*/
  if (!strcmp (mnemonic, "dlp"))
  {
    put_tag(LDLP);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldnl*/
  if (!strcmp (mnemonic, "dnl"))
  {
    put_tag(LDNL);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldc*/
  if (!strcmp (mnemonic, "dc"))
  {
    put_tag(LDC);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldnlp*/
  if (!strcmp (mnemonic, "dnlp"))
  {
    put_tag(LDNLP);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldl*/
  if (!strcmp (mnemonic, "dl"))
  {
    put_tag(LDL);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldmemstartval*/
  if (!strcmp (mnemonic, "dmemstartval"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* ldmemstartval */
    put_2_code(0x27,0xfe);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ladd*/
  if (!strcmp (mnemonic, "add"))
  {
    put_2_code(0x21,0xf6);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lsub*/
  if (!strcmp (mnemonic, "sub"))
  {
    put_2_code(0x23,0xf8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lsum*/
  if (!strcmp (mnemonic, "sum"))
  {
    put_2_code(0x23,0xf7);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldiff*/
  if (!strcmp (mnemonic, "diff"))
  {
    put_2_code(0x24,0xff);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lmul*/
  if (!strcmp (mnemonic, "mul"))
  {
    put_2_code(0x23,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldiv*/
  if (!strcmp (mnemonic, "div"))
  {
    put_2_code(0x21,0xfa);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lddevid*/
  if (!strcmp (mnemonic, "ddevid"))
  {
    put_2_code(0x21,0x27);
    put_1_code(0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lshl*/
  if (!strcmp (mnemonic, "shl"))
  {
    put_2_code(0x23,0xF6);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lshr*/
  if (!strcmp (mnemonic, "shr"))
  {
    put_2_code(0x23,0xf5);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldinf*/
  if (!strcmp (mnemonic, "dinf"))
  {
    warn_chip(T400|T414|T425|T426); /* ldinf */
    put_2_code(0x27,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lb*/
  if (!strcmp (mnemonic, "b"))
  {
    put_1_code(0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldtimer*/
  if (!strcmp (mnemonic, "dtimer"))
  {
    put_2_code(0x22,0xf2);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldpi*/
  if (!strcmp (mnemonic, "dpi"))
  {
    if (*operand) put_tag(LDPI); else put_2_code(0x21,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  lend*/
  if (!strcmp (mnemonic, "end"))
  {
    if (*operand) put_tag(LEND); else put_2_code(0x22,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ldpri*/
  if (!strcmp (mnemonic, "dpri"))
  {
    put_2_code(0x21,0xfe);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
