/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_F_C
#include "main.h"
/*}}}  */

/*{{{  mne_f*/
Bool mne_f(void)
{
  /*{{{  fptesterr*/
  if (!strcmp (mnemonic, "ptesterr"))
  {
    warn_chip(T225|T400|T425|T426|T800|T801|T805); /* fptesterr */
    put_2_code(0x29,0xfc);
    return TRUE;
  }
  /*}}}  */
  warn_chip(T800|T801|T805); /* all other floating point instructions */
  /*{{{  fmul*/
  if (!strcmp (mnemonic, "mul"))
  {
    put_2_code(0x27,0xf2);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnlsn*/
  if (!strcmp (mnemonic, "pldnlsn"))
  {
    put_2_code(0x28,0xfe);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnldb*/
  if (!strcmp (mnemonic, "pldnldb"))
  {
    put_2_code(0x28,0xfa);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnlsni*/
  if (!strcmp (mnemonic, "pldnlsni"))
  {
    put_2_code(0x28,0xf6);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnldbi*/
  if (!strcmp (mnemonic, "pldnldbi"))
  {
    put_2_code(0x28,0xf2);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldzerosn*/
  if (!strcmp (mnemonic, "pldzerosn"))
  {
    put_2_code(0x29,0xff);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldzerodb*/
  if (!strcmp (mnemonic, "pldzerodb"))
  {
    put_2_code(0x2a,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnladdsn*/
  if (!strcmp (mnemonic, "pldnladdsn"))
  {
    put_2_code(0x2a,0xfa);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnladddb*/
  if (!strcmp (mnemonic, "pldnladddb"))
  {
    put_2_code(0x2a,0xf6);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnlmulsn*/
  if (!strcmp (mnemonic, "pldnlmulsn"))
  {
    put_2_code(0x2a,0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldnlmuldb*/
  if (!strcmp (mnemonic, "pldnlmuldb"))
  {
    put_2_code(0x2a,0xf8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpstnlsn*/
  if (!strcmp (mnemonic, "pstnlsn"))
  {
    put_2_code(0x28,0xf8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpstnldb*/
  if (!strcmp (mnemonic, "pstnldb"))
  {
    put_2_code(0x28,0xf4);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpstnli32*/
  if (!strcmp (mnemonic, "pstnli32"))
  {
    put_2_code(0x29,0xfe);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpentry*/
  if (!strcmp (mnemonic, "pentry"))
  {
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fprev*/
  if (!strcmp (mnemonic, "prev"))
  {
    put_2_code(0x2a,0xf4);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpdup*/
  if (!strcmp (mnemonic, "pdup"))
  {
    put_2_code(0x2a,0xf3);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpurn*/
  if (!strcmp (mnemonic, "purn"))
  {
    put_2_code(0x22,0x42);
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpurz*/
  if (!strcmp (mnemonic, "purz"))
  {
    put_3_code(0x46,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpurp*/
  if (!strcmp (mnemonic, "purp"))
  {
    put_3_code(0x44,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpurm*/
  if (!strcmp (mnemonic, "purm"))
  {
    put_3_code(0x45,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpchkerror*/
  if (!strcmp (mnemonic, "pchkerror"))
  {
    put_2_code(0x28,0xf3);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fptesterror*/
  if (!strcmp (mnemonic, "ptesterror"))
  {
    put_2_code(0x29,0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpuclearerror*/
  if (!strcmp (mnemonic, "puclearerror"))
  {
    put_2_code(0x29,0x4c);
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpuseterror*/
  if (!strcmp (mnemonic, "puseterror"))
  {
    put_2_code(0x22,0x43);
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpgt*/
  if (!strcmp (mnemonic, "pgt"))
  {
    put_2_code(0x29,0xf4);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpeq*/
  if (!strcmp (mnemonic, "peq"))
  {
    put_2_code(0x29,0xf5);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpordered*/
  if (!strcmp (mnemonic, "pordered"))
  {
    put_2_code(0x29,0xf2);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpnan*/
  if (!strcmp (mnemonic, "pnan"))
  {
    put_2_code(0x29,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpnotfinite*/
  if (!strcmp (mnemonic, "pnotfinite"))
  {
    put_2_code(0x29,0xf3);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpuchki32*/
  if (!strcmp (mnemonic, "puchki32"))
  {
    put_3_code(0x4e,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpuchki64*/
  if (!strcmp (mnemonic, "puchki64"))
  {
    put_3_code(0x4f,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpur32tor64*/
  if (!strcmp (mnemonic, "pur32tor64"))
  {
    put_3_code(0x47,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpur64tor32*/
  if (!strcmp (mnemonic, "pur64tor32"))
  {
    put_3_code(0x48,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fprtoi32*/
  if (!strcmp (mnemonic, "prtoi32"))
  {
    put_2_code(0x29,0xfd);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpi32tor32*/
  if (!strcmp (mnemonic, "pi32tor32"))
  {
    put_2_code(0x29,0xf6);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpi32tor64*/
  if (!strcmp (mnemonic, "pi32tor64"))
  {
    put_2_code(0x29,0xf8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpb32tor64*/
  if (!strcmp (mnemonic, "pb32tor64"))
  {
    put_2_code(0x29,0xfa);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpunoround*/
  if (!strcmp (mnemonic, "punoround"))
  {
    put_3_code(0x4d,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpint*/
  if (!strcmp (mnemonic, "pint"))
  {
    put_2_code(0x2a,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpadd*/
  if (!strcmp (mnemonic, "padd"))
  {
    put_2_code(0x28,0xf7);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpsub*/
  if (!strcmp (mnemonic, "psub"))
  {
    put_2_code(0x28,0xf9);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpmul*/
  if (!strcmp (mnemonic, "pmul"))
  {
    put_2_code(0x28,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpdiv*/
  if (!strcmp (mnemonic, "pdiv"))
  {
    put_2_code(0x28,0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpuabs*/
  if (!strcmp (mnemonic, "puabs"))
  {
    put_3_code(0x4b,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpremfirst*/
  if (!strcmp (mnemonic, "premfirst"))
  {
    put_2_code(0x28,0xff);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpremstep*/
  if (!strcmp (mnemonic, "premstep"))
  {
    put_2_code(0x29,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpusqrtfirst*/
  if (!strcmp (mnemonic, "pusqrtfirst"))
  {
    put_3_code(0x41,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpusqrtstep*/
  if (!strcmp (mnemonic, "pusqrtstep"))
  {
    put_3_code(0x42,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpusqrtlast*/
  if (!strcmp (mnemonic, "pusqrtlast"))
  {
    put_3_code(0x43,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpuexpinc32*/
  if (!strcmp (mnemonic, "puexpinc32"))
  {
    put_3_code(0x4a,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpuexpdec32*/
  if (!strcmp (mnemonic, "puexpdec32"))
  {
    put_3_code(0x49,0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpumulby2*/
  if (!strcmp (mnemonic, "pumulby2"))
  {
    put_2_code(0x21,0x42);
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpudivby2*/
  if (!strcmp (mnemonic, "pudivby2"))
  {
    put_2_code(0x21,0x41);
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpsttest*/
  if (!strcmp (mnemonic, "psttest"))
  {
    put_2_code(0x28,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpldtest*/
  if (!strcmp (mnemonic, "pldtest"))
  {
    put_2_code(0x28,0xf5);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpurestore*/
  if (!strcmp (mnemonic, "purestore"))
  {
    put_2_code(0x23,0x40);
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  /*{{{  fpusave*/
  if (!strcmp (mnemonic, "pusave"))
  {
    put_2_code(0x22,0x40);
    put_2_code(0x2a,0xfb);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
