/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_D_C
#include "main.h"
/*}}}  */

/*{{{  mne_d*/
Bool mne_d(void)
{
  /*{{{  d8*/
  if (!strcmp (mnemonic, "8"))
  {
    put_tag(D8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  d16*/
  if (!strcmp (mnemonic, "16"))
  {
    put_tag(D16);
    return TRUE;
  }
  /*}}}  */
  /*{{{  d32*/
  if (!strcmp (mnemonic, "32"))
  {
    put_tag(D32);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ds*/
  if (!strcmp(mnemonic, "s"))
  {
    put_tag(DS);
    return TRUE;
  }
  /*}}}  */
  /*{{{  div*/
  if (!strcmp (mnemonic, "iv"))
  {
    put_2_code(0x22,0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  diff*/
  if (!strcmp (mnemonic, "iff"))
  {
    put_1_code(0xf4);
    return TRUE;
  }
  /*}}}  */
  /*{{{  dup*/
  if (!strcmp (mnemonic, "up"))
  {
    warn_chip(T225|T400|T425|T426|T800|T801|T805); /* dup */
    put_2_code(0x25,0xfa);
    return TRUE;
  }
  /*}}}  */
  /*{{{  dist*/
  if (!strcmp (mnemonic, "ist"))
  {
    put_2_code(0x22,0xfe);
    return TRUE;
  }
  /*}}}  */
  /*{{{  diss*/
  if (!strcmp (mnemonic, "iss"))
  {
    put_2_code(0x23,0xf0);
    return TRUE;
  }
  /*}}}  */
  /*{{{  disc*/
  if (!strcmp (mnemonic, "isc"))
  {
    put_2_code(0x22,0xff);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
