/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_C_C
#include "main.h"
/*}}}  */

/*{{{  mne_c*/
Bool mne_c(void)
{
  /*{{{  call*/
  if (!strcmp (mnemonic, "all"))
  {
    put_tag(CALL);
    return TRUE;
  }
  /*}}}  */
  /*{{{  cj*/
  if (!strcmp (mnemonic, "j"))
  {
    put_tag(CJ);
    return TRUE;
  }
  /*}}}  */
  /*{{{  cword*/
  if (!strcmp (mnemonic, "word"))
  {
    put_2_code(0x25,0xf6);
    return TRUE;
  }
  /*}}}  */
  /*{{{  csngl*/
  if (!strcmp (mnemonic, "sngl"))
  {
    put_2_code(0x24,0xfc);
    return TRUE;
  }
  /*}}}  */
  /*{{{  cflerr*/
  if (!strcmp (mnemonic, "flerr"))
  {
    warn_chip(T400|T414|T425|T426); /* cflerr */
    put_2_code(0x27,0xf3);
    return TRUE;
  }
  /*}}}  */
  /*{{{  crcword*/
  if (!strcmp (mnemonic, "rcword"))
  {
    warn_chip(T225|T400|T425|T426|T800|T801|T805); /* crcword */
    put_2_code(0x27,0xf4);
    return TRUE;
  }
  /*}}}  */
  /*{{{  crcbyte*/
  if (!strcmp (mnemonic, "rcbyte"))
  {
    warn_chip(T225|T400|T425|T426|T800|T801|T805); /* crcbyte */
    put_2_code(0x27,0xf5);
    return TRUE;
  }
  /*}}}  */
  /*{{{  csub0*/
  if (!strcmp (mnemonic, "sub0"))
  {
    put_2_code(0x21,0xf3);
    return TRUE;
  }
  /*}}}  */
  /*{{{  ccnt1*/
  if (!strcmp (mnemonic, "cnt1"))
  {
    put_2_code(0x24,0xfd);
    return TRUE;
  }
  /*}}}  */
  /*{{{  clrhalterr*/
  if (!strcmp (mnemonic, "lrhalterr"))
  {
    put_2_code(0x25,0xf7);
    return TRUE;
  }
  /*}}}  */
  /*{{{  clrj0break*/
  if (!strcmp (mnemonic, "lrj0break"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* clrj0break */
    put_2_code(0x2b,0xf2);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
