/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include <string.h>
#include <stdio.h>

#include "error.h"
#include "output.h"

#define MNE_B_C
#include "main.h"
/*}}}  */

/*{{{  mne_b*/
Bool mne_b(void)
{
  /*{{{  bitcnt*/
  if (!strcmp (mnemonic, "itcnt"))
  {
    warn_chip(T225|T400|T425|T426|T800|T801|T805); /* bitcnt */
    put_2_code(0x27,0xf6);
    return TRUE;
  }
  /*}}}  */
  /*{{{  bitrevword*/
  if (!strcmp (mnemonic, "itrevword"))
  {
    warn_chip(T225|T400|T425|T426|T800|T801|T805); /* bitrevword */
    put_2_code(0x27,0xf7);
    return TRUE;
  }
  /*}}}  */
  /*{{{  bitrevnbits*/
  if (!strcmp (mnemonic, "itrevnbits"))
  {
    warn_chip(T225|T400|T425|T426|T800|T801|T805); /* bitrevnbits */
    put_2_code(0x27,0xf8);
    return TRUE;
  }
  /*}}}  */
  /*{{{  break*/
  if (!strcmp (mnemonic, "reak"))
  {
    warn_chip(T225|T400|T425|T426|T801|T805); /* break */
    put_2_code(0x2b,0xf1);
    return TRUE;
  }
  /*}}}  */
  /*{{{  bsub*/
  if (!strcmp (mnemonic, "sub"))
  {
    put_1_code(0xf2);
    return TRUE;
  }
  /*}}}  */
  /*{{{  bcnt*/
  if (!strcmp (mnemonic, "cnt"))
  {
    put_2_code(0x23,0xf4);
    return TRUE;
  }
  /*}}}  */
  return FALSE;
}
/*}}}  */
