/*{{{}}}*/
/*{{{  #includes*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#ifdef _XOPEN_SOURCE
#include <nl_types.h>
#else
typedef long nl_catd;
static nl_catd catopen(char *name, int oflag) { return 0; }
static char *catgets(nl_catd catd, int set_id, int msg_id, char *msg) { return msg; }
static void catclose(nl_catd catd) { }
#endif

#include <sys/types.h>
#include <fcntl.h>
#include <locale.h>
#include <unistd.h>
#include <limits.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "../common/common.h"
#include "../common/buf.h"
#include "../common/error.h"
#include "error.h"
#include "output.h"

#define MAIN_C
#include "main.h"
/*}}}  */

/*{{{  invalid*/
private Bool invalid(void)
{
  return FALSE;
}
/*}}}  */
/*{{{  index table*/
private Bool (*mne[26])(void) =
{
  mne_a,
  mne_b,
  mne_c,
  mne_d,
  mne_e,
  mne_f,
  mne_g,
  invalid,
  mne_i,
  mne_j,
  invalid,
  mne_l,
  mne_m,
  mne_n,
  mne_o,
  mne_p,
  invalid,
  mne_r,
  mne_s,
  mne_t,
  mne_u,
  invalid,
  mne_w,
  mne_x,
  invalid,
  invalid
};
/*}}}  */

/*{{{  variable declarations*/
private char line[256];
public char label[64];
public char mnemonic[16];
public char operand[256];
private FILE *in=NULL;
public unsigned long num=1L;
public Chip chip=T800;
private char outfile[_POSIX_PATH_MAX];
public nl_catd catd;
/*}}}  */

/*{{{  sigterm*/
static void sigterm(int n)
{
  unlink(outfile);
  exit(1);
}
/*}}}  */
/*{{{  parse*/
private char parse(line,label,mnemonic,operand) char *line, *label, *mnemonic, *operand;
{
  /*{{{  variable declarations*/
  char m='\0';
  int len;
  /*}}}  */

  *label = *mnemonic = *operand = '\0';
  /*{{{  return if line empty or newline*/
  len=strlen(line);
  if (!len) return '\0';
  if (line[len-1]=='\n') line[len-1]='\0';
  if (*line=='\0') return '\0';
  /*}}}  */
  if (*line==' ')
  /*{{{  we have no label*/
  {
    *label='\0';
    /*{{{  skip white space and return if end of line*/
    while (*line==' ') line++;
    if (*line=='\0' || *line=='\n') return '\0';
    /*}}}  */
    /*{{{  copy mnemonic*/
    m = *line++;
    while (*line && *line!=' ') *mnemonic++ = *line++; *mnemonic='\0';
    /*}}}  */
    /*{{{  skip white space and return if end of line*/
    while (*line==' ') line++;
    if (*line=='\0') return m;
    /*}}}  */
    /*{{{  copy operand*/
    strcpy(operand,line);
    return m;
    /*}}}  */
  }
  /*}}}  */
  else
  /*{{{  copy label*/
  {
    strcpy(label,line);
    return '\0';
  }
  /*}}}  */
}
/*}}}  */

/*{{{  main*/
int main(int argc, char *argv[])
{
  /*{{{  variable declarations*/
  char m;
  int c;
  /*}}}  */

  /*{{{  locale*/
  /*
  setlocale(LC_ALL,"");
  */
  catd=catopen("as",0);
  /*}}}  */
  /*{{{  parse arguments*/
  *outfile='\0';
  while ((c = getopt(argc, argv, "?T:o:")) != -1)
  switch (c)
  {
    /*{{{  ?*/
    case '?': err=TRUE; break;
    /*}}}  */
    /*{{{  T 400|414|425|800|801|805*/
    case 'T':
    {
      if (!strcmp("400",optarg)) chip=T400;
      else if (!strcmp("414",optarg)) chip=T414;
      else if (!strcmp("425",optarg)) chip=T425;
      else if (!strcmp("800",optarg)) chip=T800;
      else if (!strcmp("801",optarg)) chip=T801;
      else if (!strcmp("805",optarg)) chip=T805;
      else err=TRUE;
      break;
    }
    /*}}}  */
    /*{{{  o file*/
    case 'o':
    {
      strcpy(outfile,optarg);
      break;
    }
    /*}}}  */
  }
  /*{{{  parse file*/
  if (!err && optind<argc)
  {
    /*{{{  variable declarations*/
    char *p;
    /*}}}  */

    if (*outfile=='\0')
    /*{{{  set outfile*/
    {
      strcpy(outfile,argv[optind]);
      p=outfile+strlen(outfile)-1;
      while (*p!='.' && p!=outfile) p--;
      if (*p=='.') *p='\0';
      strcat(outfile,OBJECT);
    }
    /*}}}  */

    if ((in=fopen(argv[optind],"r"))==(FILE*)0) fatal(1,catgets(catd,1,1,"as: can't open input file %s"),argv[optind]);
    optind++;
  }
  else err=TRUE;
  /*}}}  */
  /*{{{  if err print usage*/
  if (err)
  {
    fprintf(stderr,catgets(catd,1,2,"Usage: as [-T 400|414|425|800|801|805] [-o file] file\n"));
    exit (2);
  }
  /*}}}  */
  /*}}}  */
  signal(SIGHUP,sigterm);
  signal(SIGINT,sigterm);
  signal(SIGQUIT,sigterm);
  signal(SIGTERM,sigterm);
  /*{{{  open output file*/
  if ((out=buf_open(outfile,O_WRONLY|O_CREAT|O_TRUNC,0666))<0) fatal(1,catgets(catd,1,3,"as: can't open output file %s"),outfile);
  /*}}}  */
  while (fgets(line,sizeof(line),in))
  /*{{{  process line*/
  {
    if (line[0]!='\n' && line[0]!=';')
    {
      m=parse(line,label,mnemonic,operand);
      if (label[0]) put_label(label);
      else if (m) if (!(m>='a' && m<='z' && (*mne[m-'a'])())) lnerror(catgets(catd,1,4,"weird line"));
    }
    num++;
  }
  /*}}}  */
  if (err)
  /*{{{  remove object file and exit 1*/
  {
    unlink(outfile);
    exit(1);
  }
  /*}}}  */
  else
  /*{{{  close output file and exit 0*/
  {
    buf_close();
    exit(0);
  }
  /*}}}  */
}
/*}}}  */
