#ifndef __CHAN_H
#define __CHAN_H

typedef int CHAN;

#define Link0Output ((CHAN*)0x80000000)
#define Link0Input  ((CHAN*)0x80000010)
#define Link1Output ((CHAN*)0x80000004)
#define Link1Input  ((CHAN*)0x80000014)
#define Link2Output ((CHAN*)0x80000008)
#define Link2Input  ((CHAN*)0x80000018)
#define Link3Output ((CHAN*)0x8000000C)
#define Link3Input  ((CHAN*)0x8000001C)

CHAN *alt_chan(CHAN *chanv[], int channels);

void chan_out_byte(char c, CHAN *chan);
void chan_out_word(int n, CHAN *chan);
void chan_out_message(int len, char *message, CHAN *chan);

void chan_in_byte(char *c, CHAN *chan);
void chan_in_word(int *n, CHAN *chan);
void chan_in_message(int len, char *message, CHAN *chan);

#endif
