#!/bin/sh -e
#
# $Id: patchin.sh,v 1.14 2003/09/05 10:55:32 ducrot Exp $
#

if [ "$1" = "" ]; then
  echo "Syntax: $0 KERNELDIR"
  exit 1
fi
cpufreq=$PWD

if [ ! -f $cpufreq/patchin.sh ]; then
  echo "Please run me in the cpufreq directory"
  exit 1
fi

# update x86 files
# ****************

# create x86 files at correct location [until the arch/i386/cpu/cpufreq or
# arch/i386/kernel/cpu/cpufreq question is resolved]

mkdir $cpufreq/linux/arch/i386/kernel/cpu
mkdir $cpufreq/linux/arch/i386/kernel/cpu/cpufreq

cd linux/arch/i386/kernel/

for f in cpufreq/*; do
  ln -sf $cpufreq/linux/arch/i386/kernel/$f $cpufreq/linux/arch/i386/kernel/cpu/$f
done

# diff x86 files, save it into x86_patch

cd $cpufreq
touch $cpufreq/x86_patch

echo `diff -ruN -x CVS -x *.o $1/arch/i386/kernel/cpu/cpufreq/ linux/arch/i386/kernel/cpu/cpufreq/ > $cpufreq/x86_patch`;

rm -r $cpufreq/linux/arch/i386/kernel/cpu;

# diff existing core files, save it into core_patch
# *************************************************

touch $cpufreq/core_patch

# Still needed unless bk merge.
echo `diff -Nu $1/kernel/cpufreq.c linux/kernel/cpufreq.c > $cpufreq/core_patch`;
echo `diff -Nu $1/drivers/cpufreq/ linux/drivers/cpufreq/ >> $cpufreq/core_patch`;
echo `diff -Nu $1/include/linux/cpufreq.h linux/include/linux/cpufreq.h >> $cpufreq/core_patch`;
echo `diff -Nu $1/Documentation/cpu-freq/ linux/Documentation/cpufreq/ >> $cpufreq/core_patch`;

# apply core_patch, x86_patch and patch
# *************************************


cd $1
echo `patch -p1 -i $cpufreq/core_patch`;
echo `patch -p1 -i $cpufreq/x86_patch`;
echo `patch -p1 -i $cpufreq/patch`;
