#!/bin/sh
#
# $Id: patchin.sh,v 1.1.1.8 2005/01/04 09:18:37 ducrot Exp $
#

if [ "$1" = "" ]; then
	echo "Syntax: $0 KERNELDIR"
	exit 1
fi
cpufreq=$PWD

if [ ! -f $cpufreq/patchin.sh ]; then
	echo "Please run me in the cpufreq directory"
	exit 1
fi

rm -rf $cpufreq/linux/Documentation/cpu-freq
ln -sf cpufreq $cpufreq/linux/Documentation/cpu-freq

diff -Nur -x"*CVS*" $1/Documentation/cpu-freq linux/Documentation/cpu-freq > patch_core
diff -Nu $1/Documentation/cpufreq-old linux/Documentation/cpufreq-old >> patch_core
diff -Nu $1/include/linux/cpufreq.h linux/include/linux/cpufreq.h >> patch_core
if [ -f $1/kernel/cpufreq.c ]; then
	diff -Nu $1/kernel/cpufreq.c linux/kernel/cpufreq.c >> patch_core
fi
diff -Nur -x"*CVS*" $1/drivers/cpufreq/ linux/drivers/cpufreq/ >> patch_core

rm -f patch_x86
# note that acpi.c must not be included..
for f in elanfreq.c gx-suspmod.c longhaul.c longhaul.h longrun.c \
		p4-clockmod.c powernow-k6.c powernow-k7.c powernow-k7.h \
		powernow-k8.c powernow-k8.h speedstep-centrino.c \
		speedstep-ich.c speedstep-lib.c speedstep-lib.h \
		speedstep-piix4.c speedstep-smi.c; do
	ln -sf cpufreq/$f linux/arch/i386/kernel/
	diff -Nu $1/arch/i386/kernel/$f linux/arch/i386/kernel/$f >> patch_x86
done

cd $1
patch -p1 -i $cpufreq/patch
patch -p1 -i $cpufreq/patch_core
patch -p1 -i $cpufreq/patch_x86
