#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <pthread.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sched.h>
#include "mpi.h"

#define NTEST 10
/******************************************************/
/*                                                    */
/* Generously written and contibuted by               */
/* Douglas Johnson <djohnson@osc.edu>                 */
/*                                                    */
/******************************************************/


/******* DEFINE ONE OF THESE !!! *******/
/* CLONE, THREAD and ELSE work         */
/* THREAD does NOT work                */
#define USE_CLONE
/* #define USE_THREAD*/
/* #define USE_FORK*/
/* #define ELSE */
/***********************************************/

static int NP, IM;

void *master (void *arg) {

  int i, ir, is, istat;
  MPI_Status status;

  fprintf (stderr, "%d: master is %d\n", IM, getpid ());

  for (i = 0; i < NTEST; i++) {
    is = rand ();
    printf ("master sending %d\n", is);

    istat = MPI_Send (&is, 1, MPI_INT, 1, 1, MPI_COMM_WORLD);
    if (istat != MPI_SUCCESS) {
      fprintf (stderr, "%d: MPI_Send [%d] = %d\n", IM, i, istat);
      }

    istat = MPI_Recv (&ir, 1, MPI_INT, 1, 2, MPI_COMM_WORLD, &status);
    if (istat != MPI_SUCCESS) {
      fprintf (stderr, "%d: MPI_Recv [%d] = %d\n", IM, i, istat);
      }

    if (ir != is) {
      fprintf (stderr, "%d: corrupted data [%d] %d != %d\n", IM, i, ir, is);
      }

    }

  return 0;
  }

void *slave (void *arg) {

  int i, ir, istat;
  MPI_Status status;

  fprintf (stderr, "%d: slave is %d\n", IM, getpid ());

  for (i = 0; i < NTEST; i++) {

    istat = MPI_Recv (&ir, 1, MPI_INT, 0, 1, MPI_COMM_WORLD, &status);
    if (istat != MPI_SUCCESS) {
      fprintf (stderr, "%d: MPI_Recv [%d] = %d\n", IM, i, istat);
      }
    printf ("slave received %d\n", ir);

    istat = MPI_Send (&ir, 1, MPI_INT, 0, 2, MPI_COMM_WORLD);
    if (istat != MPI_SUCCESS) {
      fprintf (stderr, "%d: MPI_Send [%d] = %d\n", IM, i, istat);
      }

    }

  return 0;
  }

int main (int argc, char *argv []) {

  int istat;
  pid_t pid;
  pthread_t thread;
  char cstack[1000];
  void *child_stack = &cstack; 
  int flags; 

  istat = MPI_Init (&argc, &argv);
  if (istat != MPI_SUCCESS) {
    fprintf (stderr, "MPI_Init = %d\n", istat);
    exit (istat);
    }

  istat = MPI_Comm_rank (MPI_COMM_WORLD, &IM);
  if (istat != MPI_SUCCESS) {
    fprintf (stderr, "MPI_Comm_rank = %d\n", istat);
    exit (istat);
    }

  istat = MPI_Comm_size (MPI_COMM_WORLD, &NP);
  if (istat != MPI_SUCCESS) {
    fprintf (stderr, "%d: MPI_Comm_size = %d\n", IM, istat);
    exit (istat);
    }

  if (IM == 0) {
    printf ("Using 2 of %d processors\n", NP);
    }

  istat = MPI_Barrier (MPI_COMM_WORLD);
  if (istat != MPI_SUCCESS) {
    fprintf (stderr, "%d: MPI_Barrier = %d\n", IM, istat);
    exit (istat);
    }

#ifdef USE_FORK
  errno = 0;
  pid = fork ();
  if (pid == 0) {
    if (IM == 0) (void) master (0);
    if (IM == 1) (void) slave (0);
    exit (0);
    }
  else {
    if (pid == -1) {
      fprintf (stderr, "%d: fork error %d\n", IM, errno);
      }
    else {
      fprintf (stderr, "%d: %d forked %d\n", IM, getpid (), pid);
      errno = 0;
      pid = waitpid (pid, &istat, 0);
      if (pid == -1) {
        fprintf (stderr, "%d: waitpid error %d\n", IM, errno);
        }
      }
    }

#endif

#ifdef USE_THREAD
  if (IM == 0) istat = pthread_create (&thread, 0, master, 0);
  if (IM == 1) istat = pthread_create (&thread, 0, slave, 0);
  if (istat != 0) {
    fprintf (stderr, "%d: pthread_create error %d\n", IM, istat);
    }
  else {
    fprintf (stderr, "%d: %d created thread %ld\n", IM, getpid (), thread);
    }

  istat = pthread_join (thread, 0);
  if (istat != 0) {
    fprintf (stderr, "%d: pthread_join error %d\n", IM, istat);
    }
#endif

#ifdef USE_CLONE
  errno = 0;
  flags = CLONE_VM;

  if (IM == 0) istat = clone (master(0), child_stack, flags, 0);
  if (IM == 1) istat = clone (slave(0), child_stack, flags, 0);
  fprintf (stderr, "%d: clone done, with exit code %d\n", IM, istat);

#endif

#ifdef ELSE
  if (IM == 0) (void) master (0);
  if (IM == 1) (void) slave (0);

#endif

  istat = MPI_Barrier (MPI_COMM_WORLD);
  if (istat != MPI_SUCCESS) {
    fprintf (stderr, "%d: MPI_Barrier = %d\n", IM, istat);
    exit (istat);
  }

  istat = MPI_Finalize ();
  if (istat != MPI_SUCCESS) {
    fprintf (stderr, "%d: MPI_Finalize = %d\n", IM, istat);
    exit (istat);
  }
  
  return 0;
}


