/* From smc@acl.lanl.gov Tue Nov 16 18:09:50 1999 */

#include <stdio.h>
#include <mpi.h>
#include <assert.h>
FILE *MPI_DEBUG;
int mpi_rank, mpi_size;

int MPI_init(int *argc, char ***argv);
main(int argc, char **argv)
{

  int NumIter, LengthVector, i, j, k, iii, NumSend, NumRecv;
  int ll;
  long long *SendBuffer, *RecvBuffer;
  int SendRecvPEs[6144], NumSendRecvPEs;
  int RecvdData[6144];
  double CheckSum;
  int size, sizeRecv, sendSize;
  MPI_Request request[1024];
  MPI_Status status[1024], Status;
  int flag = 0;
  int flag2;
  int NCNT;
  int LenBuff;
  int errstat, iError;
  int checknode, checktag;
  long double sum, compSum, diff;
  long double buff_diff;
  long long sendbuff;
  long long NewSum;
  long double *CheckSums;
  int Test1, Test2;
  int tag;

  MPI_Init(&argc, &argv);
  if (mpi_size == 1)
    goto TAG;

  if (mpi_rank == 0) {
    printf(" Enter NumIter LengthVector \n");
#if 0
    scanf("%d%d", &NumIter, &LengthVector);
#else
    NumIter = 32766; LengthVector = 4000;
#endif
    printf("NumIter = %d  LengthVector = %d\n",NumIter,LengthVector);
  }

  if (mpi_rank == 0) {
    fprintf(MPI_DEBUG, "  sending to 1 \n");
    for (i = 1; i < mpi_size; i++)
      MPI_Send(&LengthVector, 1, MPI_INTEGER, i, 1, MPI_COMM_WORLD);
  }
  if (mpi_rank != 0) {
    fprintf(MPI_DEBUG, "  receiving \n");
    MPI_Recv(&LengthVector, 1, MPI_INTEGER, 0, 1, MPI_COMM_WORLD, &Status);
  }
  if (mpi_rank == 0) {
    fprintf(MPI_DEBUG, "  sending to 1 \n");
    for (i = 1; i < mpi_size; i++)
      MPI_Send(&NumIter, 1, MPI_INTEGER, i, 1, MPI_COMM_WORLD);
  }
  if (mpi_rank != 0) {
    fprintf(MPI_DEBUG, "  receiving \n");
    MPI_Recv(&NumIter, 1, MPI_INTEGER, 0, 1, MPI_COMM_WORLD, &Status);
  }

  size = sizeof(long long) * LengthVector;
  LenBuff = (LengthVector + mpi_size) * sizeof(long long);
  /* debug 
     printf(" LenBuff %d \n",LenBuff);
     end debug */
  SendBuffer = (long long *) malloc(LenBuff);
  assert(SendBuffer);
  /* debug 
     if(mpi_rank == 1 ) {
     printf("SendBuffer %ld LenBuff %d \n",SendBuffer,LenBuff);
     }
     end debug */
  RecvBuffer = (long long *) malloc(LenBuff);
  assert(RecvBuffer);

  fprintf(MPI_DEBUG, " size %d \n", size);
  fflush(MPI_DEBUG);


  /* figure out message pattern and results */
  /* NumSendRecvPEs = (( mpi_size > 14) ? 14 : mpi_size-1) ; */
  NumSendRecvPEs = mpi_size - 1;


  j = LengthVector + mpi_rank;
  /*   CheckSum = ((double)(j) * (double) (j-1) )/2.0 ; */
  for (i = 0; i < NumSendRecvPEs; i++) {
    SendRecvPEs[i] = mpi_rank + i + 1;
    if (SendRecvPEs[i] >= mpi_size) {
      j = SendRecvPEs[i] / mpi_size;
      SendRecvPEs[i] -= (j * mpi_size);
    }
  }

  CheckSums = (long double *) malloc((mpi_size) * sizeof(long double));
  for (i = 0; i < mpi_size; i++) {
    CheckSums[i] = 0.0;
    for (k = 0; k < (LengthVector + mpi_rank); k++)
      CheckSums[i] += (((long long) i << 48) |
		       ((long long) mpi_rank << 32) | (k << 16));
  }
  /* */

  for (iii = 0; iii < NumIter; iii++) {
    if ((iii%1000) == 0) printf("[%d]: iteration %d\n", mpi_rank, iii);
    tag = iii + 1001;

    /* send data */

    /*    fprintf(MPI_DEBUG," ******** \n"); */
    NumRecv = 0;
    for (i = 0; i < NumSendRecvPEs; i++)
      RecvdData[i] = 0;

    for (i = 0; i < NumSendRecvPEs; i++) {

      for (k = 0; k < (LengthVector + SendRecvPEs[i]); k++) {
	SendBuffer[k] = (((long long) mpi_rank << 48) |
			 ((long long) SendRecvPEs[i] << 32) |
			 (k << 16) | iii);
	/* debug  
	   if(mpi_rank == 1 ) {
	   printf("send k %d %ld %ld \n",k,SendBuffer[k],&SendBuffer[k]);
	   }
	   end debug */
      }

      sendSize = sizeof(long long) * (LengthVector + SendRecvPEs[i]);
      if (sendSize > LenBuff)
	printf(" error In sendSize \n");
      errstat = MPI_Isend(SendBuffer, sendSize, MPI_BYTE, SendRecvPEs[i],
			  tag, MPI_COMM_WORLD, &request[i]);
      if (errstat != MPI_SUCCESS)
	printf(" Error code %d \n", errstat);
      flag = 0;

      do {
	if (NumRecv < NumSendRecvPEs) {
	  errstat = MPI_Iprobe(MPI_ANY_SOURCE, tag, MPI_COMM_WORLD,
			       &flag2, &Status);
	  if (flag2) {
	    checknode = Status.MPI_SOURCE;
	    checktag = Status.MPI_TAG;
	    RecvdData[NumRecv] = checknode;
	    NumRecv++;

	    for (j = 0; j < (LengthVector + mpi_rank); j++)
	      RecvBuffer[j] = 0;

	    MPI_Get_count(&Status, MPI_BYTE, &sizeRecv);
	    if (sizeRecv < 0)
	      printf(" error In size \n");
	    if (sizeRecv > LenBuff)
	      printf(" error In size \n");
	    if (sizeRecv != ((LengthVector + mpi_rank) * sizeof(long long)))
	      printf("Error is recv size sizeRecv %d (LengthVector+mpi_rank)*sizeof(long long) %ld \n",
		     sizeRecv, ((LengthVector + mpi_rank) * sizeof(long long)));
	    iError = MPI_Recv(RecvBuffer, sizeRecv, MPI_BYTE, checknode, checktag,
			      MPI_COMM_WORLD, &Status);
	    compSum = 0.0;
	    for (j = 0; j < (LengthVector + mpi_rank); j++) {
	      compSum += (long double) RecvBuffer[j];
	      /* debug 
		 if(mpi_rank == 1 ) printf(" j %d %ld \n",j,RecvBuffer[j]);
		 end debg */
	    }

	    Test1 = (RecvBuffer[0] & 65535);
	    Test2 = (int) ((RecvBuffer[0] & ((long long) 65535 << 48))
			   >> 48);
	    diff = compSum - (CheckSums[Test2] +
			      (LengthVector + mpi_rank) * (long double) Test1);
	    if (diff < 0.0)
	      diff = -diff;
	    if (diff > 0.000000001) {
	      printf(" iteration %d  mpi_rank %d diff %Lg %Lg %Lg %d \n",
		     iii, mpi_rank, diff, (CheckSums[Test2] + (long double) Test1),
		     compSum, iError);
	      fprintf(MPI_DEBUG, " iteration %d  mpi_rank %d diff %Lg %Lg %Lg %d \n",
		      iii, mpi_rank, diff, (CheckSums[Test2] + (long double) Test1),
		      compSum, iError);

	      fprintf(MPI_DEBUG, " lsbs %x %x \n", (int)((long long)(CheckSums[Test2] + (long double) Test1) & ((long long)65535)),(int)(((long long) compSum) & ((long long) 65535)));

	      fprintf(MPI_DEBUG, " iteration %d  mpi_rank %d diff %llx %llx %llx %d \n",
		      iii, mpi_rank, (long long) diff, (long long)(CheckSums[Test2] + (long double) Test1),
		      (long long) compSum, iError);

	      for (k = 0; k < LengthVector + mpi_rank; k++) {

		sendbuff = (((long long) Test2  << 48) |
			    ((long long) mpi_rank << 32) |
			    (k << 16) | iii);
#if 0
		buff_diff = RecvBuffer[k] - sendbuff;
		if (buff_diff < 0.0)
		  buff_diff = -buff_diff;
		if (buff_diff > 0.000000001) 
#endif
                if (RecvBuffer[k] != sendbuff)
		{
							     
		  fprintf(MPI_DEBUG, " DIFF at %x:\n", k);
		  fprintf(MPI_DEBUG, "%04x", (unsigned int) (RecvBuffer[k] >> 48));
		  fprintf(MPI_DEBUG, "%04x", (unsigned int) ((RecvBuffer[k] >> 32) & 65535));
		  fprintf(MPI_DEBUG, "%04x", (unsigned int) ((RecvBuffer[k] >> 16) & 65535));
		  fprintf(MPI_DEBUG, "%04x", (unsigned int) (RecvBuffer[k] & 65535));
		  fprintf(MPI_DEBUG, "\n");

		  fprintf(MPI_DEBUG, "%04x", (unsigned int) (sendbuff >> 48));
		  fprintf(MPI_DEBUG, "%04x", (unsigned int) ((sendbuff >> 32) & 65535));
		  fprintf(MPI_DEBUG, "%04x", (unsigned int) ((sendbuff >> 16) & 65535));
		  fprintf(MPI_DEBUG, "%04x", (unsigned int) (sendbuff & 65535));
		  fprintf(MPI_DEBUG, "\n");
          fprintf(MPI_DEBUG,"%016llx\n",((unsigned long long)sendbuff)^((unsigned long long)RecvBuffer[k]));
		}

#if 0
		fprintf(MPI_DEBUG, " %08x ", (int) (RecvBuffer[k] >> 48));
		fprintf(MPI_DEBUG, " %08x ", (int) ((RecvBuffer[k] >> 32) & 65535));
		fprintf(MPI_DEBUG, " %08x ", (int) ((RecvBuffer[k] >> 16) & 65535));
		fprintf(MPI_DEBUG, " %08x ", (int) (RecvBuffer[k] & 65535));
		fprintf(MPI_DEBUG, "\n");
#endif
	      }
	      fprintf(MPI_DEBUG, "\n");
	    }
	  }
	}
	MPI_Test(&request[i], &flag, &status[i]);
      } while (!flag);
      /*        fprintf(MPI_DEBUG," Msg to %d\n",SendRecvPEs[i]); */
    }


    /* receive data */
    if (NumRecv == NumSendRecvPEs)
      goto TAG2;
    do {

      flag = 0;
      NCNT = 0;
      do {
	errstat = MPI_Iprobe(MPI_ANY_SOURCE, tag, MPI_COMM_WORLD,
			     &flag, &Status);
	/*
	  NCNT++;
	  if(NCNT == 1000000 ) {
	  fprintf(MPI_DEBUG," NumRecv %d iii %d \n",NumRecv,iii);
	  for (j=0 ; j < NumSendRecvPEs ; j++)
	  fprintf(MPI_DEBUG,"RecvdData [%d] = %d \n",j,RecvdData[j]);
	  }
	  fflush(MPI_DEBUG);
	*/
      } while (!flag);

      checknode = Status.MPI_SOURCE;
      checktag = Status.MPI_TAG;
      RecvdData[NumRecv] = checknode;
      NumRecv++;

      for (j = 0; j < (LengthVector + mpi_rank); j++)
	RecvBuffer[j] = 0;

      MPI_Get_count(&Status, MPI_BYTE, &sizeRecv);
      if (sizeRecv < 0)
	printf(" error In size \n");
      if (sizeRecv > LenBuff)
	printf(" error In size \n");
      iError = MPI_Recv(RecvBuffer, sizeRecv, MPI_BYTE, checknode, checktag,
			MPI_COMM_WORLD, &Status);
      compSum = 0.0;
      for (j = 0; j < (LengthVector + mpi_rank); j++) {
	compSum += (double long) RecvBuffer[j];
	/* debug 
	   if(mpi_rank == 1 ) printf(" j %d %ld \n",j,RecvBuffer[j]);
	   end debg */
      }
      Test1 = (RecvBuffer[0] & 65535);
      Test2 = (int) ((RecvBuffer[0] & ((long long) 65535 << 48)) >> 48);
      /* debug 
	 printf(" mpi_rank %d Test1 %d Test2 %d \n",mpi_rank,Test1,Test2);
	 end debug */
      diff = compSum - (CheckSums[Test2] +
			(LengthVector + mpi_rank) * (long double) Test1);
      if (diff < 0.0)
	diff = -diff;
      if (diff > 0.000000001) {
	printf(" iteration %d mpi_rank %d diff %Lg %Lg %Lg %d \n",
	       iii, mpi_rank, diff, (CheckSums[Test2] + (long double) Test1),
	       compSum, iError);
	fprintf(MPI_DEBUG, " iteration %d mpi_rank %d diff %Lg %Lg %Lg %d \n",
		iii, mpi_rank, diff, (CheckSums[Test2] + (long double) Test1),
		compSum, iError);
	for (k = 0; k < sizeRecv; k++) {
	  fprintf(MPI_DEBUG, " %08x ", (int) (RecvBuffer[k] >> 48));
	  fprintf(MPI_DEBUG, " %08x ", (int) ((RecvBuffer[k] >> 32) & 65535));
	  fprintf(MPI_DEBUG, " %08x ", (int) ((RecvBuffer[k] >> 16) & 65535));
	  fprintf(MPI_DEBUG, " %08x ", (int) (RecvBuffer[k] & 65535));
	  fprintf(MPI_DEBUG, "\n");
	}
	fprintf(MPI_DEBUG, "\n");
      }
    } while (NumRecv < NumSendRecvPEs);


    /* debug */
    /*   MPI_Barrier(MPI_COMM_WORLD); */
    /* end debug */
  TAG2:
    ;
    if (((iii / 10) * 10) == iii) {
      fprintf(MPI_DEBUG, " End iter %d \n", iii);
      fflush(MPI_DEBUG);
    }
  }
 TAG:
  printf("mpifinalize called \n");
  fprintf(MPI_DEBUG, " loop exited \n");
  fflush(MPI_DEBUG);

  free(SendBuffer);
  free(RecvBuffer);

  MPI_Finalize();
  exit(0);
}



int 
MPI_Init(int *argc, char ***argv)
{

  char FileName[12];
  int stat, status;
  status = PMPI_Init(argc, argv);
  stat = PMPI_Comm_rank(MPI_COMM_WORLD, &mpi_rank);
  stat = PMPI_Comm_size(MPI_COMM_WORLD, &mpi_size);
  sprintf(&FileName[0], "MPIdebug");
  sprintf(&FileName[8], "%d", mpi_rank);
  MPI_DEBUG = fopen(FileName, "wb");
  fprintf(MPI_DEBUG, "File Opened\n");
  return status;
}
