#ifndef mpibip_h
#define mpibip_h

#include "bip.h"
#include <assert.h>
#define gm_assert assert
#if GM_DEBUG
#define gm_assert_p assert
#else
#define gm_assert_p(a) 
#endif

#define GMPI_ROUNDUP(x) (((x)+3)&~3)
/* for BIP size is length expressed in words, whereas a GM size== log2(length) have same meaning */
#define GMPI_CONTROL_TAG 50 /* 50 mots = 200 bytes */
#define DATA_MESSAGE_SIZE gm_min_size_for_length
#define GMPI_MAX_FRAG 25000 /* maximumu message = 10Kbytes (temporary) */
#define gm_bcopy(s,d,n) memcpy((d),(s),(n))

typedef void * gmpi_port;
#define gm_dma_malloc(p,l) malloc(l)
#define gm_dma_free(p,b) free(b)
#define gm_close(a) 
#define gm_min_size_for_length(l) (((l)+3)/4)
#define gm_max_length_for_size(l) ((l)*4)

#define GMPI_DATA_HEADER_LEN 0
#define GMPI_MAX_NUMNODES 48
#define GMPI_CREDITS 6 /* we assume this is strictly > 1 because we cannot send credits back otherwise */
#define GMPI_NETDATA_HEADER_LEN 0
#define GMPI_NSTOKEN 1
#define GMPI_FIRST_TAG 1
#define GMPI_NTAGS 1

struct gmpi_arch_var {
  long rid[NTAGS];
  void *rbuf;
  long sid;
  struct _MPIR_SHANDLE *shandle;
  void *sbuf;
};

#define MPID_PKT_MAX_DATA_SIZE 160

#define GMPI_SEND_HEAD_LEN 0
#define GMPI_SEND_NETDATA(p) ((void*)(p))
#define GMPI_SEND_HEAD(p) (p)

#define gmpi_need_scopy(data,len) (((long)(data)&3) || (len & 3))
#define gmpi_need_rcopy(data,len) (((long)(data)&3) || (len & 3))


#endif
