#ifndef _channel_h
#define _channel_h

#include "gmpi.h"

void gmpi_send_control(void *data, long length, unsigned int dest, int prepend);

/* I need to have this defined - CHECK this */
/* ch2/channel.c has lots of stuff to decide which to use... */

#define MPID_SendControl(pkt, size, dest)  \
{ (pkt)->src = MPID_MyWorldRank; gmpi_send_control(pkt,size,dest,0); }

#define MPID_SendControlBlock(pkt, size, dest)  \
{ (pkt)->src = MPID_MyWorldRank; gmpi_send_control(pkt,size,dest,0); }






#define MPID_DRAIN_INCOMING \
    while (MPID_DeviceCheck( MPID_NOTBLOCKING ) != -1) ;
#ifdef MPID_TINY_BUFFERS 
#define MPID_DRAIN_INCOMING_FOR_TINY(is_non_blocking) \
{if (is_non_blocking) {MPID_DRAIN_INCOMING;}}
#else
#define MPID_DRAIN_INCOMING_FOR_TINY(is_non_blocking)
#endif

/* 
   These macros control the conversion of packet information to a standard
   representation.  On homogeneous systems, these do nothing.
 */
#ifdef MPID_HAS_HETERO
#define MPID_PKT_PACK(pkt,size,dest) MPID_CH_Pkt_pack((MPID_PKT_T*)(pkt),size,dest)
#define MPID_PKT_UNPACK(pkt,size,src) MPID_CH_Pkt_unpack((MPID_PKT_T*)(pkt),size,src)
#else
#define MPID_PKT_PACK(pkt,size,dest) 
#define MPID_PKT_UNPACK(pkt,size,src) 
#endif

MPID_Device *MPID_CH_InitSelfMsg(int * argc, char ***argv, int short_len, int long_len);

#endif /* _channel_h */


