#!/usr/local/bin/perl

$| =1;
$program = shift(@ARGV) || "0";
if ($program eq "0") {
	print "usage: rwcp.pl <rwcp_bw | rwcp_rtt>\n";
	exit;
}

$lens="4 8 12 16 24 32 48 64 96 128 192 256 384 512 768 1024 1280 1440 1468 1536 \
       2048 3072 4096 6144 8192 12288 16384 24576 32768 49152 65536 98304 131072 \
       196608 262144 393216 524288 786432 1048576";
@length = split(' ',$lens);

#print "$lens, @length, $length\n";

if ($program eq "rwcp_bw") {
	printf("# msg_len(bytes)  bytes/sec   Mbytes/sec\n");
}
elsif ($program eq "rwcp_rtt") {
	printf("#msg_len(bytes)  rtt(usec)   one-way(usec)\n");
}
else {
	print "program argument '$program' not understood\n";
	print "usage: rwcp.pl <rwcp_bw | rwcp_rtt>\n";
	exit;
}

while ($len = shift(@length)) {
	$command = "../../bin/mpirun.ch_gm -np 2 $program -len $len |";
#	print "$command \n";
	$pid = open (FOOBAR, $command);
	if (!$pid) {
		print "Couldn't run command '$command'\n";
		exit;
	}
	while (<FOOBAR>) {
		print;
	}
	close(FOOBAR);
}

