C Date: 7 Nov 1999 06:51:39 -0000
C  
C  Brian Baltz, 1999 AHPCC
C  ping_pong.f -- two-process ping-pong -- send from 0 to 1 and send back
C      from 1 to 0
C  Integrity of the message is checked after receipt
C 
C  Input: none
C
      PROGRAM PingPong
      INCLUDE 'mpif.h'
      integer    p
      integer    my_rank
      integer    test
      integer    min_size  
      integer    max_size 
      integer    incr 
      integer    size
      parameter  (min_size = 0, max_size = 10000, incr = 200)
      parameter  (size = 80000)
      double precision x(0:size)
      integer    pass
      integer    status(MPI_STATUS_SIZE)
      integer    ierr
      integer    i
      double precision wtime_overhead
      double precision start, finish,timex
      double precision raw_time, cumulativ,y,tmin
      double precision dtime(0:127,0:127),delta,tmax,tavg
      double precision tmax2,tmin2,tavg2
      integer    comm, count(0:127)
      integer    MAX_ORDER, MAX
      parameter  (MAX_ORDER = 1000, MAX = 8)
      character*23 nodes(0:127),dummy
      character*4 pname(0:127), myname
C
      call MPI_INIT( ierr)
      call MPI_COMM_SIZE(MPI_COMM_WORLD,  p, ierr )
      call MPI_COMM_RANK(MPI_COMM_WORLD,  my_rank, ierr )
      call MPI_COMM_DUP(MPI_COMM_WORLD,  comm, ierr )
      call MPI_GET_PROCESSOR_NAME(myname,len,ierr)

      call MPI_GATHER(myname,4,MPI_CHARACTER,pname,4,
     +         MPI_CHARACTER,0,MPI_COMM_WORLD,ierr)
      call MPI_BCAST(pname,512,MPI_CHARACTER,0,MPI_COMM_WORLD,ierr)
	if(my_rank.eq.0) print*,"Starting..."
C
C
	y=4.D0*DATAN(1.D0)
	do 9 i=1,size
	    x(i)=y
9 	continue

	noff=mod(p,2)
C	mynoff=mod(myrank,2)
	if(noff.eq.1) then
          print*, "Error: odd number of processes..."
          stop
        endif
        print 181, my_rank
	tavg=0.D0
	tmin=99.D99
	tmax=0.D0
        delta=3.0D-004 
C        nloops=20
        nloops=200
        mynoff=mod(my_rank,2)
        do 101 nnn=0,1
        do 100 i=1,p-1,2
            ndest=my_rank+i
            nsend=my_rank-i
            if(ndest.ge.p) ndest=mod(ndest,p)
            if(nsend.lt.0) nsend=nsend+p
            call MPI_BARRIER(comm, ierr)
                  if (mynoff.eq.nnn) then
                     timex=0.D0
                     do 20 k=1,nloops
                       start = MPI_WTIME()
                       call MPI_SEND(x, size,MPI_DOUBLE_PRECISION,
     +                 ndest,0,comm,ierr)
                       finish = MPI_WTIME()
                       timex=timex+(finish-start)
11	   	    continue
20 		     continue
                    ttime=timex/dble(nloops)
		    tavg=tavg+ttime
                    if(ttime.gt.tmax) tmax=ttime
                    if(ttime.lt.tmin) tmin=ttime
                  else
                     nflag=0
                     do 22 k=1,nloops
                     call MPI_RECV(x,size,MPI_DOUBLE_PRECISION,nsend,
     +                           0,comm,status, ierr)
                     do 21 k1=1,size
                       if (DABS(x(k1)-y).gt.1D-16) then
		        	print 179, x(k1)
                                print 182, nsend,comm,status,ierr
		        	print 180, my_rank, k1, k1
		        	print 178, y
				nflag=1
		       endif
21	   	    continue
22	           continue
		   if(nflag.eq.1)print 177, pname(nsend),
     +                pname(my_rank),nsend,my_rank
                  endif
100	continue
101     continue

	call MPI_REDUCE(tmin, tmin2, 1, MPI_DOUBLE_PRECISION, MPI_MIN, 0,
     +       MPI_COMM_WORLD, ierr) 
	call MPI_REDUCE(tmax, tmax2, 1, MPI_DOUBLE_PRECISION, MPI_MAX, 0,
     +       MPI_COMM_WORLD, ierr) 
	call MPI_REDUCE(tavg, tavg2, 1, MPI_DOUBLE_PRECISION, MPI_SUM, 0,
     +       MPI_COMM_WORLD, ierr) 
	if (my_rank.eq.0) then
	   print*,"Max time: ",tmax2
	   print*,"Min time: ",tmin2
	   print*,"Avg time: ",tavg2/dble(p**2/4)
	endif

176   format("Excessive Message Delay?: ",A," -> ",A,2x,I3,2x,I3,
     +       2x,D17.10)
177   format("Message Error: ",A," -> ",A,2x,I3,2x,I3,2x,D17.10,2x,
     +       D17.10)
181   format(2x,"my rank ", I5)
178   format(10x,"Sent: ",Z17)
179   format(10x,"Recv: ",Z17)
182   format(5x,"Message from",2x,I3,3x,"comm",2x,I4,3x,"status",
     +       2x,Z8,3x,"ierr",2x,I4)
180   format(12x,"my rank ",I4,3x,"index ",I8,3x,"in hex",Z8)

      call MPI_FINALIZE(ierr)
      end





