# file main.tcl
# This file contains the main procedure refresh
# which is the main loop of the software.
#----------------------------------------------------------------------------
# procedure refresh
# 
#      this procedure goes through the listOfHosts list and for each
#      of the hosts listed collects the relevent information
#----------------------------------------------------------------------------

proc refresh {} {

    global upTime numProcesses listOfHosts load1 load5 load15 loads freeMemory
    global time numUsers colour display error
    
    # for each of the hosts in the listOfHosts
    # update its informations
    
    foreach host $listOfHosts {
	
	# reset the error flag
	unSetError $host
	."$host"HostName configure \
	    -fg $colour(hostNameBG) \
	    -bg $colour(hostNameFG)
	update

	# check if the host is alive
	# if not hen set error flag 

	set pingResult [pingHost $host]
	
	if {$pingResult} {
	    setError $host
	} else { 
	    
	    # we only do the following if host is alive !
	    # if not then give up
	    # get uptime
	    set upTimeResult [getUpTime $host]
	}
	update
	
	# check for errors

	if {$upTimeResult == "error"} {
	    setError $host
	}
	update

	# if there was an error then set error
	# status for this host and return
	
	if {$error($host)} {
	    setError $host
	} else {
	    displayUpTime $host $upTimeResult
	}
	update
	
	# get number of processes if number of processes column
	# is enabled and there was no error in previous operation
	if {$display(numProcesses) && ($error($host) == 0)} {
	    set numProcessesResult [getNumberOfProcesses $host]
	    if {$numProcessesResult == "error"} {
		setError $host
	    } else {
		displayNumberOfProcesses $host $numProcessesResult
	    }
	    update
	}
	
	# if no previous errors then
	# collect the memory information from /proc/meminfo
	# and store it locally

	if {$error($host)} {
	} else {
	    set memInfoResult [getMemInfo $host]
	    if {$memInfoResult == "error"} {
		setError $host
	    }
	}
	
	update
	
	# get total memory if the total memory column is enabled
	# and no errors were detected in previous operations on this host

	if {$display(totalMemory) && ($error($host) == 0)} {
	    set totalMemResult [getTotalMemory $host]
	    if {$totalMemResult == "error"} {
		setError $host
	    } else {
		displayTotalMemory $host $totalMemResult
	    }
	    update
	}
	
	# get free memory 
	if {$display(freeMemory) && ($error($host) == 0)} {
	    set freeMemResult [getFreeMemory $host]
	    if {$freeMemResult == "error"} {
		setError $host
	    } else {
		displayFreeMemory $host $freeMemResult
	    }
	    update
	}


	# get shared memory if there were no previous errors
	# and this display is enabled
	if {$display(sharedMemory) && ($error($host) == 0)} {
	    set sharedMemResult [getSharedMemory $host]
	    if {$sharedMemResult == "error"} {
		setError $host
	    } else {
		displaySharedMemory $host $sharedMemResult
	    }
	    update
	}


	# get buffers
	if {$display(buffers) && ($error($host) == 0)} {
	    set buffersResult [getBuffers $host]
	    if {$buffersResult == "error"} {
		setError $host
	    } else {
		displayBuffers $host $buffersResult
	    }
	    update
	}


	# get cache 
	if {$display(cache) && ($error($host) == 0)} {
	    set cacheResult [getCache $host]
	    if {$cacheResult == "error"} {
		setError $host
	    } else {
		displayCache $host $cacheResult
	    }
	    update
	}


	# get Total Swap
	if {$display(totalSwap) && ($error($host) == 0)} {
	    set totSwapResult [getTotalSwap $host]
	    if {$totSwapResult == "error"} {
		setError $host
	    } else {
		displayTotalSwap $host $totSwapResult
	    }
	    update
	}


	# get Free Swap
	if {$display(freeSwap) && ($error($host) == 0)} {
	    set freeSwapResult [getFreeSwap $host]
	    if {$freeSwapResult == "error"} {
		setError $host
	    } else {
		displayFreeSwap $host $freeSwapResult
	    }
	    update
	}

	# if we had any errors than we set the colour of the host name label
	# to error color.  If there were no errors then we reset the coulour
	# to the original.
	
	if {$error($host)} {
	    ."$host"HostName configure \
		-fg $colour(errorBG) \
		-bg $colour(errorFG)
	} else {
	    	."$host"HostName configure \
	    -fg $colour(hostNameFG) \
	    -bg $colour(hostNameBG)
	}
    }
    
    # update the screen after each host's info
    # has been collected
    update
}

