#----------------------------------------------------------------------------
# procedure displayUpTime
#
#     this procedure accepts as an argument the result
#     of getUpTime procedure call.
#     It splits this one long string into 3 load values, system time
#     and number of users on the system checking for errors 
#     and displays it on the screen.
#
# args 
#     host   - name of this host
#     uptime - uptime result for this host.  if there was an error
#              in obtaining this result then the value will be "error" 
#----------------------------------------------------------------------------

proc displayUpTime {host upTimeResult} {

    global load1 load5 load15 time numUsers colour loadLimit blank display debug
   
    regexp {([0-9]+\.[0-9]+), ([0-9]+\.[0-9]+), ([0-9]+\.[0-9]+)} \
	"$upTimeResult" loadInfo 
    
    if {$debug} {
	puts "displayUpTime($host) : upTimeResult =  $upTimeResult"
	puts "displayUpTime($host) : loadInfo =  $loadInfo"
    }
    
    # check if time should be displayed
    if {$display(time)} {
	regexp {([0-9]+:[0-9]+)} \
	    "$upTimeResult" time($host)
	."$host"time configure \
	    -fg $colour(neutralFG)
    }

    # check if number of users should be displayed
    if {$display(numUsers)} { 
	regexp {([0-9]+ user.)} \
	    "$upTimeResult" numUsers($host)
	
	."$host"numUsers configure \
	    -fg $colour(neutralFG)
    }
    
    # now we split this string into a list of three number
    set loadsList [split $loadInfo ,]
    set load1($host)  [lindex $loadsList 0]
    set load5($host)  [lindex $loadsList 1]
    set load15($host) [lindex $loadsList 2]
    
        
    if {$display(load1)} {
	# determine the colour of 1 minute load
	if {$load1($host) > $loadLimit(firstWarning)} {
	    if {$load1($host) > $loadLimit(secondWarning)} {
		if {$load1($host) > $loadLimit(error)} {
		    ."$host"load1 configure \
			-fg $colour(errorBG) \
			-bg $colour(errorFG)
		} else {
		    ."$host"load1 configure \
			-fg $colour(secondWarningFG)
		}
	    } else {
		."$host"load1 configure \
		    -fg $colour(firstWarningFG)
	    }
	} else {
	    ."$host"load1 configure \
		-fg $colour(neutralFG)
	}
    }
    

    if {$display(load5)} {
	# determine the colour of 1 minute load
	if {$load5($host) > $loadLimit(firstWarning)} {
	    if {$load5($host) > $loadLimit(secondWarning)} {
		if {$load5($host) > $loadLimit(error)} {
		    ."$host"load5 configure \
			-fg $colour(errorBG) \
			-bg $colour(errorFG)
		} else {
		    ."$host"load5 configure \
			-fg $colour(secondWarningFG)
		}
	    } else {
		."$host"load5 configure \
		    -fg $colour(firstWarningFG)
	    }
	} else {
	    ."$host"load5 configure \
		-fg $colour(neutralFG)
	}
    }
    

    if {$display(load15)} {
	# determine the colour of 1 minute load
	if {$load15($host) > $loadLimit(firstWarning)} {
	    if {$load15($host) > $loadLimit(secondWarning)} {
		if {$load15($host) > $loadLimit(error)} {
		    ."$host"load15 configure \
			-fg $colour(errorBG) \
			-bg $colour(errorFG)
		} else {
		    ."$host"load15 configure \
			-fg $colour(secondWarningFG)
		}
	    } else {
		."$host"load15 configure \
		    -fg $colour(firstWarningFG)
	    }
	} else {
	    ."$host"load15 configure \
		-fg $colour(neutralFG)
	}
    }
    

}


#----------------------------------------------------------------------------
# procedure displayNumberOfProcesses
#
#----------------------------------------------------------------------------

proc displayNumberOfProcesses {host numProcs} {

    global colour numProcesses

    regexp {[0-9]+} $numProcs numProcesses($host) 
}


#----------------------------------------------------------------------------
# procedure displayTotalMemory
#
#----------------------------------------------------------------------------

proc displayTotalMemory {host totalMem} {

    global colour totalMemory

    regexp {[0-9]+} "$totalMem" totalMemory($host)
    set totalMemory($host) "[expr $totalMemory($host) / 1024] Mb"
}


#----------------------------------------------------------------------------
# procedure displayFreeMemory
#
#----------------------------------------------------------------------------

proc displayFreeMemory {host freeMem} {

    global colour freeMemory freeMemLimit

    regexp {[0-9]+} "$freeMem" freeMemory($host)
#    set freeMemory($host) "[expr $freeMemory($host) / 1024] Mb"

    # colour
    
    if {$freeMemory($host) < $freeMemLimit(firstWarning)} {
	if {$freeMemory($host) < $freeMemLimit(secondWarning)} {
	    if {$freeMemory($host) < $freeMemLimit(error)} {
		."$host"freeMemory configure \
		    -fg $colour(errorBG) \
		    -bg $colour(errorFG)
	    } else {
		."$host"freeMemory configure \
		    -fg $colour(secondWarningFG)
	    }
	} else {
	    ."$host"freeMemory configure \
		-fg $colour(firstWarningFG)
	}
    } else {
	."$host"freeMemory configure \
	    -fg $colour(neutralFG)
    }    
	    
    set freeMemory($host) "$freeMemory($host) Kb"
}


#----------------------------------------------------------------------------
# procedure displaySharedMemory
#
#----------------------------------------------------------------------------

proc displaySharedMemory {host shared} {

    global sharedMemory

    regexp {[0-9]+} "$shared" sharedMemory($host)
    set sharedMemory($host) "[expr $sharedMemory($host) / 1024] Mb"
}


#----------------------------------------------------------------------------
# procedure displayBuffers
#
#----------------------------------------------------------------------------

proc displayBuffers {host buff} {

    global buffers

    regexp {[0-9]+} "$buff" buffers($host)
    set buffers($host) "[expr $buffers($host) / 1024] Mb"
}


#----------------------------------------------------------------------------
# procedure displayCache
#
#----------------------------------------------------------------------------

proc displayCache {host c} {

    global cache

    regexp {[0-9]+} "$c" cache($host)
    set cache($host) "[expr $cache($host) / 1024] Mb"
}


#----------------------------------------------------------------------------
# procedure displayTotalSwap
#
#----------------------------------------------------------------------------

proc displayTotalSwap {host tSwap} {

    global totalSwap

    regexp {[0-9]+} "$tSwap" totalSwap($host)
    set totalSwap($host) "[expr $totalSwap($host) / 1024] Mb"
}


#----------------------------------------------------------------------------
# procedure display freeSwap
#
#----------------------------------------------------------------------------

proc displayFreeSwap {host fSwap} {

    global freeSwap freeSwapLimit colour

    regexp {[0-9]+} "$fSwap" freeSwap($host)
    if {$freeSwap($host) < $freeSwapLimit(firstWarning)} {
	if {$freeSwap($host) < $freeSwapLimit(secondWarning)} {
	    ."$host"freeSwap configure \
		-fg $colour(secondWarningFG)
	} else {
	    ."$host"freeSwap configure \
		-fg $colour(firstWarningFG)
	}
    } else {
	."$host"freeSwap configure \
	    -fg $colour(neutralFG)
    }    
    set freeSwap($host) "[expr $freeSwap($host) / 1024] Mb"
}

