/*									tab:2
 *
 * time_am.c - measure short active messages
 *
 * "Copyright (c) 1995 by Lok Tin Liu and The Regents of the University 
 * of California.  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Author: 			Lok Tin Liu
 * Version:			463
 * Creation Date:	Mon May 15 12:48:00 1995
 * Filename:		time_am.c
 * History:
 *
 */

#ifndef MAX
#define MAX(a,b) (a<b) ? b:a;
#endif

#ifndef MIN
#define MIN(a,b) (a<b) ? a:b;
#endif

static char _version_string_[] = "\nVersion:532:time_am.sc\0\n";

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "gm.h"			/* needed for 'inline' in logp_main.h */
#include "logp_main.h"
#include "logp_stat.h"
#include <assert.h>

int delay_count = 0;

int myproc = 0;

double slope, base; /* base (intercept) and slope of the time vs. iterations curve*/

static
int process_batch(int *my_iter_array, double *my_sec_array, double *mean_ptr, double *cnf_int_ptr)
{
	int j, keep_going;

	GM_PARAMETER_MAY_BE_UNUSED (_version_string_);
	
	/* process all BATCH number of calls */
	for (j=0;j<BATCH;j++){
		switch(keep_going=stats_global(my_iter_array[j], my_sec_array[j], mean_ptr, cnf_int_ptr)){
		  case -1: case 0:
			j=BATCH; /* quit calling stats_global  */
			break;
		  default:
			break;
		}
	}
	
	return (keep_going);
	
}

/*
 * my_delay: executes a loop `d' times
 *
 * requires: all_time_1us must have been called previously
 * 
 * returns: last loop iteration (so that compiler doesn't optimize it away)
 *
 * side-effects:  none
 *
 */

#define ITERS 1024

int my_delay( int d )  {
	int i, ct=0;
	
	for (i=0;i<d;i++){
	  ct=(((ct+i)*30)/(i+8));
	  ct=(((ct+i)*31)/(i+7));
	  ct=(((ct+i)*32)/(i+6));
	  ct=(((ct+i)*33)/(i+5));
	  ct=(((ct+i)*34)/(i+4));
	  ct=(((ct+i)*35)/(i+3));
	  ct=(((ct+i)*36)/(i+2));
	  ct=(((ct+i)*37)/(i+1));
	}
	delay_count ++;
	return ct;
}



/*
 * all_time_1us: Compute how much time it takes to iterate thru a loop
 *
 * requires: nothing
 * 
 * returns: nothing
 *
 * side-effects: modifies the global variables base and slope
 * on node 0 only.
 *
 */

void 	
all_time_1us(double *base1, double *slope1) {
    int i,iter, n = 1, keep_going;
    double over, sec, mean=0.0, cnf_int;
    int mean_small = (mean < 1000.0);
    double divi;
    double t0;
    
    /*First find the overhead of calling the delay function with
      0 iterations of work...*/
	
  printf("all_time_1us: finding overhead of delay function\n");
  fflush(stdout);

	/* Start over if the conf. interval is unacceptable */
  start_over_base:
    stats_initialize();
    iter = 0;
    base = 0.0;
    
    keep_going = 1;
    
    if (MYPROC == 0){
      while (keep_going) {
	TIME_USEC_new(
		      for (i =0;i< 100*ITERS; i++)
		      my_delay(0);
		      );
	TIME_USEC_N_NOP(100*ITERS);
        divi = (double)(100*ITERS);
	sec = (sec - over)/(divi);
	keep_going = stats_global(iter,sec,&mean,&cnf_int);
	if (keep_going == -1) /*max iterations exceeded error*/ {
	  goto start_over_base;
	}
	iter++;
      }
    }
    base = mean;								/*The intercept of the curve in us*/
    

  printf("all_time_1us: finding slope of the line\n");
  fflush(stdout);

	/* Start over if the conf. interval is unacceptable */
  start_over_mean:
	n = 1;
	mean_small = 1;
	
    /*Now find out the slope of the line*/
    while (mean_small) {				
      stats_initialize();
      iter = 0;
      keep_going = 1;
		
      while (keep_going) {
	
	if (MYPROC == 0){
	  TIME_USEC_new(
			for (i=0; i < ITERS; i++)
			my_delay(n);
			);
	  TIME_USEC_N_NOP(ITERS);
	  divi = (double) ITERS;
	  sec = (sec - over)/(divi);
	  keep_going = stats_global(iter,sec,&mean,&cnf_int);
	}
	iter++;
	if (keep_going == -1) {
	  goto start_over_mean;
	}
      }
      if (mean <100){
	mean_small = 1;
      }
      else
	mean_small = 0;

      n<<=1;
    }	
    /*	So now we know the startup cost, base, and the number of iterations
		it takes to get more than 1ms of time.  So compute the slope*/
    n>>=1; 
    slope = (mean - base) / n;
    
    on_one {

#if 1
		printf("Delay function:\n");
		printf(" base %f\n",base);
		printf(" slope %f\n",slope);
		printf(" mean %f, n %d\n",mean, n);
		printf(" # of iterations required to reach 1 us %d\n", (int) (n/(mean)));
                fflush(stdout);
#endif

       *base1 = base;
       *slope1 = slope;

    }
    
    if (MYPROC !=0) {
		slope = 1.0;						/*Define the value on other procs. to prevent f.p. errors*/
    }
}

