/*									tab:2
 *
 * main.h - various macros and declarations
 *
 * "Copyright (c) 1994 by Lok Tin Liu and The Regents of the University 
 * of California.  All rights reserved."
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice and the following
 * two paragraphs appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Author: 			Lok Tin Liu
 * Version:			31
 * Creation Date:	Mon Oct 10 14:47:13 1994
 * Filename:		main.h
 * History:
 */



#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef PAM
#define pam_poll() am_poll()
#else
#define pam_poll() 
#endif

/* split-c look alike goo */
extern int myproc; 
extern int procs;
extern int procslog ;
extern int unsigned max_size; 

#define MYPROC myproc 
#define PROCS procs 
#define PROCSLOG procslog

#define on_one   if (myproc == 0) 

/* HP cycle timers */
#ifdef HPAM 
#define   GETITMR(x) asm("mfctl %%itmr,%0" : "=r" (x))
#define   HP_MEGAHERTZ 99.0
#endif 

#if GM_OS_HPUX
#define double float
#endif

double get_useconds(void);


#ifdef HPAM 
extern unsigned int t0_prime;

#define TIME_USEC(code) \
    { \
    register unsigned int t0, t1; \
    GETITMR(t0); \
    (code); \
    GETITMR(t1); \
    if ( t1 > t0) \
      sec = ((double) (t1 - t0)) / (double) HP_MEGAHERTZ; \
    else \
      sec = ((double) (t1 + (0xffffffff-t0))) / (double) HP_MEGAHERTZ; \
}

/*t0_prime will be inited inside of the code*/
#define TIME_USEC_prime(code) \
    { \
    register unsigned int t1; \
    (code); \
    GETITMR(t1); \
    if ( t1 > t0_prime) \
      sec = ((double) (t1 - t0_prime)) / (double) HP_MEGAHERTZ; \
    else \
      sec = ((double) (t1 + (0xffffffff-t0_prime))) / (double) HP_MEGAHERTZ; \
}

#define TIME_USEC_N(code, n) \
    { \
    int i; \
    register unsigned int  t0, t1; \
    GETITMR(t0); \
    for (i = 0; i < n; i++) {(code);} \
    GETITMR(t1); \
     if ( t1 > t0) \
      sec = ((double) (t1 - t0))/ (double) HP_MEGAHERTZ; \
    else \
      sec = ((double) (t1 + (0xffffffff-t0))) / (double) HP_MEGAHERTZ; \
}


static gm_inline
double
time_usec_n_nop(n) {
    int i;
    register unsigned int t0, t1;
    GETITMR(t0);
    for (i = 0; i < n; i++);
    GETITMR(t1);
    if ( t1 > t0)
      return ((double) (t1 - t0))/ (double) HP_MEGAHERTZ;
    else
      return ((double) (t1 + (0xffffffff-t0))) / (double) HP_MEGAHERTZ;
}

#define TIME_USEC_N_NOP (n) do {					\
  over = time_usec_n_nop (n);						\
} while (0)

    

#define TIME_USEC_N_NOP_DEST(n) \
    { \
    int i, dest=1; \
    register unsigned int t0, t1; \
    GETITMR(t0); \
			for (i = 0; i < n; i++){\
					if (dest == (PROCS))\
					  dest = 1;\
					dest++;} \
    GETITMR(t1); \
    if ( t1 > t0) \
      over = ((double) (t1 - t0))/ (double) HP_MEGAHERTZ; \
    else \
      over = ((double) (t1 + (0xffffffff-t0))) / (double) HP_MEGAHERTZ; \
}


#define TIME_USEC_I_J_K_NOP(i_max,j_max,k_max) \
{ \
    int i,j,k; \
    register unsigned int t0, t1; \
    GETITMR(t0); \
    for (i = 0; i < i_max; i++) \
           for (j=0;j<j_max;j++) \
               for (k=0;k<k_max;k++) ;\
    GETITMR(t1); \
    if ( t1 > t0) \
      over = ((double) (t1 - t0)) / (double) HP_MEGAHERTZ; \
    else \
      over = ((double) (t1 + (0xffffffff-t0))) / (double) HP_MEGAHERTZ; \
}

#else /*HPAM*/

extern double t0_prime;


#define TIME_USEC_new(code) \
  t0 = get_useconds();\
  {code}\
  sec = (get_useconds() - t0);

#define TIME_USEC_prime_new(code) \
    {code} \
    sec = (get_useconds() - t0_prime); 

#define TIME_USEC(code) \
    { \
    double t0, t1; \
    t0 = get_useconds(); \
    (code); \
    sec = (get_useconds() - t0); \
}



#define TIME_USEC_prime(code) \
    double  t1; \
    {code} \
    sec = (get_useconds() - t0_prime); \
}

#define TIME_USEC_N(code, n) \
    { \
    int i; \
		double t0, t1; \
    t0 = get_useconds(); \
    for (i = 0; i < n; i++) {(code);} \
    sec = (get_useconds() - t0); \
}


static gm_inline
double
time_usec_n_nop (int n) {
    int i;
    double t0;
    t0 = get_useconds();
    for (i = 0; i < n; i++);
    return (get_useconds() - t0);
}

#define TIME_USEC_N_NOP(n) do {						\
    over = time_usec_n_nop (n);						\
} while (0)


#define TIME_USEC_N_NOP_old(n) \
{ \
    int i; \
    double t0, t1; \
    t0 = get_useconds(); \
    for (i = 0; i < n; i++); \
    over = (get_useconds() - t0); \
}

#define TIME_USEC_N_NOP_DEST(n) \
    { \
    int i, dest = 1; \
		double t0, t1; \
    t0 = get_useconds(); \
			for (i = 0; i < n; i++){\
					if (dest == (PROCS))\
					  dest = 1;\
					dest++;} \
    over = (get_useconds() - t0); \
}


#define TIME_USEC_I_J_K_NOP(i_max,j_max,k_max) \
{ \
                        int i,j,k; \
                        double t0, t1; \
                        t0 = get_useconds(); \
                        for (i = 0; i < i_max; i++) \
                        for (j=0;j<j_max;j++) \
                        for (k=0;k<k_max;k++) ;\
                        over = (get_useconds() - t0); \
}

#endif 

#define MAIN_TITLE(name) \
  on_one { \
    printf("\n\n"); \
    printf("++++++++++++++++++++++++++++++++++++++++++++++++++++++\n"); \
    printf("+++   %s\n", name);  \
    printf("++++++++++++++++++++++++++++++++++++++++++++++++++++++\n"); \
  }

#define TEST_RESULTS(dscr, func, mean, cnf_int)  \
  LIN_TEST_RESULTS(dscr, func, mean, cnf_int, (double)0, (double)0)

extern void LIN_TEST_RESULTS(char *one_dscr, char *one_func_name, double b0, double b0_cnf, 
		      double b1, double b1_cnf);

extern volatile int counter;
extern volatile int eureka_ctr;
extern volatile int flag;

extern void my_handler(void);
extern void reply_handler(void);
extern void cmp_handler(void);
extern void return_value_handler(void);
extern void reply_handler_delay(void);
extern void reply_handler_delay_timer(void);
extern void flush_cache(void);

extern int my_delay (int d);
extern void all_time_1us(double *base1, double *slope1);

extern int verbose;
extern unsigned int check;
extern int limit;

#define START_SIZE      8
#define GRANULARITY	2
#define MAX_SIZE        (1024*1024 + 8192 + 32)
#define MAX_ITER        1024
#define BUF_ALIGN 32
#if PAM
#define WINDOW_SIZE 8   /* Only for PAM */
#endif
extern char bulkdata0[MAX_SIZE];
extern char bulkdata1[MAX_SIZE];
extern double all_reduce_to_one_dmax(double val);

#define BATCH 50

extern int iter_array[];
extern double sec_array[];
#endif /* __MAIN_H__ */




