#include <stdio.h>
#include <string.h>

#include "gm_internal.h"

gm_port_t *g_port;


char new_hostname[GM_MAX_HOST_NAME_LEN + 8];

static
void
usage (void)
{
  printf("\nusage: gm_setname [-B board] <-h <hostname>>\n");

  printf("-B #   specifies board number (default = 0)\n");
  printf("-h <string> specifies the hostname to write into the card\n");
  printf("\n");
  gm_exit(GM_FAILURE);
}

static int
gm_setname (int argc, char *argv[])
{
	gm_status_t status;
	int portid = 1;
	int board_id = 0;
	unsigned int my_id = 0;
	int sethostname=0;

	for (argc--, argv++; argc; argc--, argv++) {
		if (strcmp(*argv, "-B") == 0) {
			argc--, argv++;
			if (!argc) {
				printf("Board number expected after '-B'.\n");
				usage();
			}
			if (sscanf(*argv, "%i", &board_id) != 1
					|| board_id < 0
					|| board_id > 1000) {
				printf("bad board number: %d\n", board_id);
				usage();
			}
			continue;
		}
		else if (strcmp(*argv, "-h") == 0) {
			argc--, argv++;
			if (!argc) {
				printf("hostname expected after '-h'.\n");
				usage();
			}
			sethostname++;
			gm_bzero(new_hostname,GM_MAX_HOST_NAME_LEN+8);
			strncpy(new_hostname,(const char *)*argv,GM_MAX_HOST_NAME_LEN);
			continue;
		}
	}

	if (!sethostname) {
		printf("must set hostname with '-h <hostname>'\n");
		usage();
	}

	status = _gm_open_common(&g_port, board_id, portid,
							 "gm-sethostname", GM_API_VERSION_1_0);
	if (status == GM_SUCCESS) {
	    status = gm_get_node_id(g_port,&my_id);
		if (status != GM_SUCCESS) {
			/* ignore the failure and try to set my name as id==0 */
			/* printf("Couldn't get the GM id\n"); */
			/* goto closeit; */
		}
		status = _gm_set_host_name(g_port, my_id, new_hostname);
		if (status != GM_SUCCESS) {
			printf("Couldn't set the GM host name for id=%d\n",my_id);
		}
		else {
			printf("Set hostname of this node (id=%d) board=%d to '%s'\n", 
				my_id,board_id, new_hostname);
			new_hostname[0] = 0;
			gm_get_host_name(g_port,new_hostname);
			printf("Read    name of this node (id=%d) board=%d as '%s'\n",
				my_id,board_id,new_hostname);
		}
	}
 
closeit:
	gm_close(g_port);

	return(0);
}

#define GM_MAIN gm_setname
#include "gm_main.h"
