/******************************************************************-*-c-*-
 * Myricom GM networking software and documentation                      *
 * Copyright (c) 1996, 1997 by Myricom, Inc.                             *
 * All rights reserved.  See the file `COPYING' for copyright notice.    *
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gm.h"

#define MY_PRIORITY GM_LOW_PRIORITY

void my_spin(struct gm_port *p, int n, int debug, int dest_port, char *buffer, int dont_wait);

#if disabled_000605
static
unsigned int
strlen8(char *s)
{
	return ((unsigned int) strlen(s) + 7) & 0xfffffff8;
}
#endif

int
main(int argc, char **argv)
{
	static struct gm_port *p1 = NULL, *p2 = NULL;
	static void *buffer1 = NULL, *buffer2 = NULL;
	GM_PARAMETER_MAY_BE_UNUSED (argc);
	GM_PARAMETER_MAY_BE_UNUSED (argv);

	if (gm_open(&p1, 0, 2, "gm_basic_p1", GM_API_VERSION_1_0) != GM_SUCCESS) {
		printf("Couldn't open port 'p1' = %d\n",2);
		exit(-1);
	}

	if (gm_open(&p2, 0, 4, "gm_basic_p2", GM_API_VERSION_1_0) != GM_SUCCESS) {
		printf("Couldn't open port 'p2' = %d \n",4);
		gm_close(p1);
		gm_exit(GM_FAILURE);
	}

	if ((buffer1 = gm_dma_calloc(p1, 1, 256)) != 0) {
		printf("Buffer 1 allocated at 0x%p\n\n", buffer1);
	}
	else {
		printf("Couldn't allocate buffer 1\n");
    	gm_close(p1);
    	gm_close(p2);
		gm_exit(GM_FAILURE);
	}

	if ((buffer2 = gm_dma_calloc(p2, 1, 256)) != 0) {
		printf("Buffer 2 allocated at 0x%p\n\n", buffer2);
	}
	else {
		printf("Couldn't allocate buffer 2\n");
    	gm_close(p1);
    	gm_close(p2);
		gm_exit(GM_FAILURE);
	}

#define REREGISTER_PAGE 0
#if REREGISTER_PAGE 
	printf("Trying to re-register\n");
	gm_register_memory(p1,buffer2,256);
	gm_register_memory(p2,buffer1,256);
#endif

	strcpy(buffer1, "Buffer1 sending ...");
	strcpy(buffer2, "Buffer2 sending ...");
	gm_free_send_tokens(p1, MY_PRIORITY, gm_num_send_tokens(p1));
	gm_free_send_tokens(p2, MY_PRIORITY, gm_num_send_tokens(p2));

	my_spin(p1, 10000, 0, 2, buffer1, 1);
	my_spin(p2, 10000, 0, 4, buffer2, 1);

    gm_close(p1);
    gm_close(p2);
    gm_exit(GM_SUCCESS);
    return(0);
}

void
my_spin(struct gm_port *p, int n, int debug, int dest_port, char *buffer, int dont_wait)
{
	void **ptr;
	gm_recv_event_t *e;
	int todo, send_pending = dont_wait, packets_to_send, packets_to_receive,
	    got_recv_buffer = 0;
	int sent_events = 0, recv_events = 0;
	gm_s64_t start, delay;
	double avg;
	unsigned int my_id;

	todo = 2 * n;
	packets_to_send = n;
	packets_to_receive = n;


    if (gm_get_node_id(p,&my_id) != GM_SUCCESS) {
        fprintf(stderr,"Couldn't get my gmID\n");
		my_id = 1;
    }

    printf("My gmID is %d\n",my_id);


	start = gm_ticks(p);

	while (todo) {
		e = gm_receive(p);

		switch (gm_ntoh_u8 (e->recv.type)) {
		 case GM_FAST_RECV_EVENT:
		 case GM_FAST_PEER_RECV_EVENT:
			 --todo;
			 ++recv_events;
			 send_pending = 1;
			 --packets_to_receive;
			 got_recv_buffer = 0;

			 if (debug == 2)
			   {
			     printf ("Received : %s length %x size %x sender_port %x sender_node %x\n",
				     (char *) gm_ntohp (e->recv.message),
				     gm_ntoh_u32 (e->recv.length),
				     gm_ntoh_u8 (e->recv.size),
				     gm_ntoh_u8 (e->recv.sender_port_id),
				     gm_ntoh_u16 (e->recv.sender_node_id));
			     printf("\n");
			 }
			 else if (debug == 1) {
				 printf("Receive #%d : \"%s\"\n",
					recv_events,
					(char *) gm_ntohp (e->recv.message));
			 }

			 break;

		 case GM_SENT_EVENT:
			 --todo;
			 ++sent_events;

			 if (debug == 2) {
				 printf("Send confirmed. Messages :\n");
				 if (gm_ntohp (e->sent.message_list))
					 for (ptr = (void **) gm_ntohp (e->sent.message_list); *ptr; ++ptr)
						 printf("\t%s\n", (char *) *ptr);
				 else
					 printf("e->sent.message_list is %08lx\n", (unsigned long) gm_ntohp (e->sent.message_list));
				 printf("\n");
			 }
			 else if (debug == 1) {
				 printf("Sent    #%d\n", sent_events);
			 }
			 gm_free_send_token(p, MY_PRIORITY);

			 break;

		 case GM_NO_RECV_EVENT:
			 break;

		 default:
			 gm_unknown(p, e);
		}

		if (send_pending && packets_to_send) {
			if (gm_alloc_send_token(p, MY_PRIORITY)) {
				gm_send(p, buffer, 6,
					(unsigned long) strlen(buffer),
					MY_PRIORITY, my_id, dest_port);
				send_pending = 0;
				--packets_to_send;
			}
			else {
				printf("Couldn't get any send tokens!\n");
			}
		}

		if (packets_to_receive && !got_recv_buffer) {
			gm_provide_receive_buffer(p, buffer + 64, 6, MY_PRIORITY);
			got_recv_buffer = 1;
		}
	}
	printf("\n");

	delay = (gm_s64_t)gm_ticks(p) - start;

	avg = (double)delay;
	avg = avg / n / 2;

	printf("Average loopback latency is: %4.1f\n\n", avg);

}


/*
  This file uses feldy indentation:

  Local Variables:
  tab-width:4
  c-file-style:"bsd"
  End:
*/
