/*
  PersistentStringSelection.java
  finucane@myri.com
  May, 1998

  Get the latest scoop package from
  http://www.myri.com/staff/finucane

*/

import java.awt.*;
import java.awt.event.*;
import java.awt.datatransfer.*;
import java.io.*;
import java.util.*;

/*modified sun sample code*/

public class PersistentStringSelection implements Transferable, ClipboardOwner
{
  final static int STRING = 0;
  final static int PLAIN_TEXT = 1;
  DataFlavor flavors[] = {DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
  private String data;
                                      
  public PersistentStringSelection(String data)
  {
    this.data = data;
  }
  public synchronized DataFlavor[] getTransferDataFlavors()
  {
    System.out.println ("getTransferDataFlavors");
    return flavors;
  }
  public boolean isDataFlavorSupported(DataFlavor flavor)
  {
    System.out.println ("isDataFlavorSupported");
    return (flavor.equals(flavors[STRING]) || flavor.equals(flavors[PLAIN_TEXT]));
  }
  public void setData (String data)
  {
    System.out.println ("setData: " + data);
    this.data = data;
  }
  public synchronized Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException
  {
    System.out.println ("getTransferData");
    if (flavor.equals(flavors[STRING]))
      return (Object)data;
    else if (flavor.equals(flavors[PLAIN_TEXT]))
      return new StringReader(data);
    else
      throw new UnsupportedFlavorException(flavor);
        
  }
  public void lostOwnership(Clipboard clipboard, Transferable contents)
  {
    System.out.println ("lostOwnership");
  }
}

