/*
  test_mapper.c
  mapper test program
  finucane@myri.com (David Finucane)
*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <signal.h>

#include "mt_Calculator.h"
#include "mt_Simulation.h"
#include "sm_Simulator.h"
#include "mt_Args.h"

#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)

static void printLine (char*s)
{
  printf ("%s\n", s);
  fflush (stdout);
}

static sm_Simulator*simulator = 0;
/*
static void handleSignal (int)
{
  if (simulator)
    simulator->abort ();
}
*/
int main (int argc, char *argv[]) 
{
  mt_Component::initialize (printLine);

  mt_Args*args = new mt_Args (argc, argv);
  if (!args)
    die (("arg"));
  
  mt_Calculator*calculator;
  mt_Simulation*simulation;
  
  /*
    signal (SIGINT, handleSignal);
    signal (SIGTERM, handleSignal);
  */
  if (!(calculator = mt_getCalculator ()))
    die (("mt_getCalculator failed"));
  
  if (!(calculator->parseArgs (args)))
  {
    mt_Args::usage ();
    calculator->usage ();
    return 1;
  }
  
  simulation = mt_getSimulation ();
  if (!simulation)
    die (("mt_getSimulation failed"));
  
  if (!(simulation->parseArgs (args)))
  {
    mt_Args::usage ();
    simulation->usage ();
    return 1;
  }
  
  simulator = (sm_Simulator*) mt_getNetwork ();
  if (!simulator)
    die (("couldn't create simulator"));
  
  if (!(simulator->parseArgs (args)))
  {
    mt_Args::usage ();
    simulator->usage ();
    return 1;
  }
  
  if (!simulator->initialize (calculator, simulation))
    die (("couldn't initialize simulator"));
  
  simulator->run ();

  simulator->simpleDump(stdout);
  
  calculator->cleanup ();
  simulator->cleanup ();
  
  delete calculator;
  delete simulation;
  delete simulator;
  
  return 0;
}
