/*
  test_graph_match.c
  finucane@myri.com
*/

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#include "mt_Component.h"
#include "mt_MapFile.h"
#include "mt_Graph.h"


#define die(s){mt_Component::printFormat s; exit (1);}
#define insist(e) do { if (!(e)) {mt_Component::printFormat ("Assertion failed in file %s, line %d",__FILE__,__LINE__); goto exception;}} while (0)
#define insistp(e, s) do { if (!(e)) {mt_Component::printFormat s; goto exception;}} while (0)


static void printLine (char*s)
{
  printf ("%s\n", s);
}

int main (int argc, char*argv [])
{
  mt_Component::initialize (printLine);
  mt_Route route;
  
  if (argc != 3)
    die (("usage: %s <mapfile1> <mapfile2>", argv [0]));

  mt_MapFile mf1 (argv[1], mt_File::_READ);
  mt_MapFile mf2 (argv[2], mt_File::_READ);
  mt_Graph g1, g2;

  if (!mf1.read (&g1))
    die (("main: couldn't parse map file %s", argv[1]));

  if (!mf2.read (&g2))
    die (("main: couldn't parse map file %s", argv[2]));

  if (g1.equals (&g2))
    printLine ("equal");
  else
    printLine ("not equal");
  
  return 0;
}




